/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.cache;

import ai.libs.jaicore.ml.cache.DataProvider;
import ai.libs.jaicore.ml.cache.Instruction;
import ai.libs.jaicore.ml.cache.InstructionFailedException;
import ai.libs.jaicore.ml.cache.LoadDataSetInstruction;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.weka.WekaInstances;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import weka.core.Instances;

public class LoadDataSetInstructionForARFFFile
extends LoadDataSetInstruction {
    private static final long serialVersionUID = -9005760846394433953L;
    private final int classIndex;

    public LoadDataSetInstructionForARFFFile(File file) {
        this(file, -1);
    }

    public LoadDataSetInstructionForARFFFile(File file, int classIndex) {
        super(DataProvider.ARFFFILE, file.getAbsolutePath());
        this.classIndex = classIndex;
    }

    @Override
    public List<IDataset> getOutputInstances(List<IDataset> inputs) throws InstructionFailedException, InterruptedException {
        try {
            Instances data = new Instances((Reader)new FileReader(new File(this.getId())));
            data.setClassIndex(this.classIndex >= 0 ? this.classIndex : data.numAttributes() - 1);
            return Arrays.asList(new WekaInstances(data));
        }
        catch (IOException | ClassNotFoundException | NumberFormatException e) {
            throw new InstructionFailedException(e);
        }
    }

    @Override
    public Instruction clone() {
        return new LoadDataSetInstructionForARFFFile(new File(this.getId()));
    }
}

