/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.cache;

import ai.libs.jaicore.ml.cache.DataProvider;
import ai.libs.jaicore.ml.cache.Instruction;
import ai.libs.jaicore.ml.cache.InstructionFailedException;
import ai.libs.jaicore.ml.cache.LoadDataSetInstruction;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.weka.WekaInstances;
import ai.libs.jaicore.ml.openml.OpenMLHelper;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import weka.core.Instances;

@JsonIgnoreProperties(value={"provider"})
public class LoadDatasetInstructionForOpenML
extends LoadDataSetInstruction {
    private static final long serialVersionUID = 2125875356626308199L;
    private final String apiKey;

    public LoadDatasetInstructionForOpenML(@JsonProperty(value="apiKey") String apiKey, @JsonProperty(value="id") int id) {
        super(DataProvider.OPENML, String.valueOf(id));
        this.apiKey = apiKey;
    }

    @Override
    public List<IDataset> getOutputInstances(List<IDataset> inputs) throws InstructionFailedException, InterruptedException {
        OpenMLHelper.setApiKey(this.apiKey);
        try {
            Instances instances = OpenMLHelper.getInstancesById(Integer.valueOf(this.getId()));
            return Arrays.asList(new WekaInstances(instances));
        }
        catch (IOException | ClassNotFoundException | NumberFormatException e) {
            throw new InstructionFailedException(e);
        }
    }

    public String getApiKey() {
        return this.apiKey;
    }

    @Override
    public Instruction clone() {
        return new LoadDatasetInstructionForOpenML(this.apiKey, Integer.valueOf(this.getId()));
    }
}

