/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.cache;

import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.ml.cache.Instruction;
import ai.libs.jaicore.ml.cache.InstructionFailedException;
import ai.libs.jaicore.ml.cache.SplitInstruction;
import ai.libs.jaicore.ml.core.dataset.DatasetCreationException;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.IOrderedDataset;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.stratified.sampling.AttributeBasedStratiAmountSelectorAndAssigner;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.stratified.sampling.StratifiedSampling;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class StratifiedSplitSubsetInstruction
extends SplitInstruction {
    private static final String NAME = "Stratified";
    @JsonProperty
    private final long seed;

    public StratifiedSplitSubsetInstruction(@JsonProperty(value="seed") long seed, @JsonProperty(value="ratios") double ratios) {
        super(NAME, ratios);
        this.seed = seed;
    }

    @Override
    public List<IDataset> getOutputInstances(List<IDataset> inputs) throws InstructionFailedException, InterruptedException {
        if (inputs.size() != 1) {
            throw new IllegalArgumentException("StratifiedSplit needs exactly one input.");
        }
        IOrderedDataset input = (IOrderedDataset)inputs.get(0);
        AttributeBasedStratiAmountSelectorAndAssigner stratiBuilder = new AttributeBasedStratiAmountSelectorAndAssigner();
        StratifiedSampling sampler = new StratifiedSampling(stratiBuilder, stratiBuilder, new Random(this.seed), input);
        sampler.setSampleSize((int)Math.ceil((double)input.size() * this.getPortionOfFirstFold()));
        ArrayList<IDataset> output = new ArrayList<IDataset>(2);
        try {
            Object subsample = sampler.call();
            output.add((IDataset)subsample);
            output.add((IDataset)sampler.getComplement());
            return output;
        }
        catch (AlgorithmExecutionCanceledException | AlgorithmException | AlgorithmTimeoutedException | DatasetCreationException e) {
            throw new InstructionFailedException((Exception)e);
        }
    }

    public long getSeed() {
        return this.seed;
    }

    @Override
    public Instruction clone() {
        return new StratifiedSplitSubsetInstruction(this.seed, this.getPortionOfFirstFold());
    }
}

