/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.multiclass;

import java.util.LinkedList;
import weka.classifiers.Classifier;
import weka.core.Capabilities;
import weka.core.Instance;
import weka.core.Instances;
import weka.core.Utils;

public class Ensemble
extends LinkedList<Classifier>
implements Classifier {
    private static final long serialVersionUID = -4094417200499766748L;

    public void buildClassifier(Instances data) throws Exception {
        for (Classifier c : this) {
            c.buildClassifier(data);
        }
    }

    public double classifyInstance(Instance instance) throws Exception {
        int best = 0;
        double[] dist = this.distributionForInstance(instance);
        for (int i = 1; i < dist.length; ++i) {
            if (!(dist[i] > dist[best])) continue;
            best = i;
        }
        return best;
    }

    public double[] distributionForInstance(Instance instance) throws Exception {
        double[] sums = new double[instance.classAttribute().numValues()];
        for (Classifier c : this) {
            double[] newProbs = c.distributionForInstance(instance);
            for (int j = 0; j < newProbs.length; ++j) {
                int n = j;
                sums[n] = sums[n] + newProbs[j];
            }
        }
        if (Utils.eq((double)Utils.sum((double[])sums), (double)1.0)) {
            return sums;
        }
        Utils.normalize((double[])sums);
        return sums;
    }

    public Capabilities getCapabilities() {
        return null;
    }
}

