/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import weka.core.Attribute;
import weka.core.DenseInstance;
import weka.core.Instance;
import weka.core.Instances;

public class WekaInstancesFeatureUnion {
    public Instances merge(Instances dataA, Instances dataB) {
        if (dataA == null || dataB == null) {
            throw new IllegalArgumentException("Instances objects must not be null.");
        }
        LinkedList<Instances> datasetList = new LinkedList<Instances>();
        datasetList.add(dataA);
        datasetList.add(dataB);
        return this.merge(datasetList);
    }

    public Instances merge(Collection<Instances> data) {
        if (data.size() < 1) {
            throw new IllegalArgumentException("Merge cannot be invoked with empty collection of Instances");
        }
        if (data.size() == 1) {
            return data.iterator().next();
        }
        boolean allEqualSize = true;
        Iterator<Instances> dataIt = data.iterator();
        Instances currentInstances = dataIt.next();
        while (dataIt.hasNext()) {
            Instances nextInstances = dataIt.next();
            if (currentInstances.size() != nextInstances.size()) {
                allEqualSize = false;
                break;
            }
            currentInstances = nextInstances;
        }
        if (!allEqualSize) {
            throw new IllegalArgumentException("The sizes of the provided Instances objects are not equal, Instance should only differ in the features not in the instances itself.");
        }
        ArrayList<Attribute> mergedAttributeList = new ArrayList<Attribute>();
        HashMap<Attribute, Attribute> attributeMap = new HashMap<Attribute, Attribute>();
        Attribute classAttribute = null;
        String relationName = null;
        Integer size = null;
        int ns = 0;
        for (Instances dataset : data) {
            if (classAttribute == null) {
                classAttribute = dataset.classAttribute().copy(ns + "-" + dataset.classAttribute().name());
                attributeMap.put(dataset.classAttribute(), classAttribute);
            }
            if (relationName == null) {
                relationName = dataset.relationName();
            }
            if (size == null) {
                size = dataset.size();
            }
            for (int i = 0; i < dataset.numAttributes(); ++i) {
                if (i == dataset.classIndex()) continue;
                Attribute copiedAttribute = dataset.attribute(i).copy(ns + "-" + dataset.attribute(i).name());
                mergedAttributeList.add(copiedAttribute);
                attributeMap.put(dataset.attribute(i), copiedAttribute);
            }
            ++ns;
        }
        mergedAttributeList.add(classAttribute);
        Instances mergedInstances = new Instances("FeatureUnionInstances-" + relationName, mergedAttributeList, size.intValue());
        mergedInstances.setClassIndex(mergedInstances.numAttributes() - 1);
        for (int i = 0; i < size; ++i) {
            DenseInstance iNew = new DenseInstance(mergedAttributeList.size());
            iNew.setDataset(mergedInstances);
            for (Instances dataset : data) {
                Instance iDataset = dataset.get(i);
                for (int j = 0; j < dataset.numAttributes(); ++j) {
                    Attribute originalKey = null;
                    for (Attribute key : attributeMap.keySet()) {
                        if (key != iDataset.attribute(j)) continue;
                        originalKey = key;
                    }
                    if (originalKey == null) continue;
                    iNew.setValue((Attribute)attributeMap.get(dataset.attribute(j)), iDataset.value(dataset.attribute(j)));
                }
            }
            mergedInstances.add((Instance)iNew);
        }
        return mergedInstances;
    }
}

