/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.attribute.timeseries;

import ai.libs.jaicore.ml.core.dataset.attribute.IAttributeType;
import ai.libs.jaicore.ml.core.dataset.attribute.IAttributeValue;
import ai.libs.jaicore.ml.core.dataset.attribute.timeseries.TimeSeriesAttributeValue;
import java.util.stream.Stream;
import org.nd4j.linalg.api.ndarray.INDArray;
import org.nd4j.linalg.factory.Nd4j;

public class TimeSeriesAttributeType
implements IAttributeType<INDArray> {
    private int length;

    public TimeSeriesAttributeType(int length) {
        this.length = length;
    }

    @Override
    public boolean isValidValue(INDArray value) {
        return value.rank() == 1 && value.length() == (long)this.length;
    }

    @Override
    public IAttributeValue<INDArray> buildAttributeValue(Object value) {
        if (value instanceof INDArray) {
            return new TimeSeriesAttributeValue(this, (INDArray)value);
        }
        throw new IllegalArgumentException("Value has to be an INDArray");
    }

    @Override
    public IAttributeValue<INDArray> buildAttributeValue(String stringDescription) {
        double[] data = Stream.of(stringDescription.split(",")).mapToDouble(Double::parseDouble).toArray();
        int[] shape = new int[]{data.length};
        INDArray value = Nd4j.create((double[])data, (int[])shape);
        return this.buildAttributeValue(value);
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("the length has to be greater than or equal to zero.");
        }
        this.length = length;
    }

    @Override
    public String getStringDescriptionOfDomain() {
        return "INDArrays of rank 1 and length " + this.length;
    }
}

