/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.infiles.stratified.sampling;

import ai.libs.jaicore.basic.TempFileHandler;
import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.ml.core.dataset.ArffUtilities;
import ai.libs.jaicore.ml.core.dataset.sampling.SampleElementAddedEvent;
import ai.libs.jaicore.ml.core.dataset.sampling.infiles.AFileSamplingAlgorithm;
import ai.libs.jaicore.ml.core.dataset.sampling.infiles.ReservoirSampling;
import ai.libs.jaicore.ml.core.dataset.sampling.infiles.stratified.sampling.IStratiFileAssigner;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.WaitForSamplingStepEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StratifiedFileSampling
extends AFileSamplingAlgorithm {
    private Logger logger = LoggerFactory.getLogger(StratifiedFileSampling.class);
    private Random random;
    private TempFileHandler tempFileHandler;
    private BufferedReader reader;
    private IStratiFileAssigner assigner;
    private int datapointAmount;
    private int streamedDatapoints;
    private boolean stratiSamplingStarted;
    private boolean stratiSamplingFinished;
    private ExecutorService executorService;
    private List<String> sample;

    public StratifiedFileSampling(Random random, IStratiFileAssigner stratiFileAssigner, File input) {
        super(input);
        this.random = random;
        this.assigner = stratiFileAssigner;
        this.tempFileHandler = new TempFileHandler();
    }

    public AlgorithmEvent nextWithException() throws InterruptedException, AlgorithmExecutionCanceledException, AlgorithmException {
        switch (this.getState()) {
            case CREATED: {
                try {
                    this.assigner.setArffHeader(ArffUtilities.extractArffHeader((File)this.getInput()));
                    this.assigner.setTempFileHandler(this.tempFileHandler);
                    this.datapointAmount = ArffUtilities.countDatasetEntries((File)this.getInput(), true);
                    this.streamedDatapoints = 0;
                    this.stratiSamplingStarted = false;
                    this.stratiSamplingFinished = false;
                    this.sample = new LinkedList<String>();
                    this.reader = new BufferedReader(new FileReader((File)this.getInput()));
                    this.executorService = Executors.newCachedThreadPool();
                    ArffUtilities.skipWithReaderToDatapoints(this.reader);
                    return this.activate();
                }
                catch (IOException e) {
                    throw new AlgorithmException((Throwable)e, "Was not able to count the datapoints.");
                }
            }
            case ACTIVE: {
                if (this.streamedDatapoints < this.datapointAmount) {
                    try {
                        String datapoint = this.reader.readLine();
                        if (datapoint != null && datapoint.trim().length() > 0 && datapoint.trim().charAt(0) != '%') {
                            this.assigner.assignDatapoint(datapoint);
                        }
                        ++this.streamedDatapoints;
                        return new SampleElementAddedEvent(this.getId());
                    }
                    catch (IOException e) {
                        throw new AlgorithmException((Throwable)e, "Was not able to read datapoint line form input file");
                    }
                }
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    throw new AlgorithmException((Throwable)e, "Was not able to close input file reader.");
                }
                if (!this.stratiSamplingStarted) {
                    this.stratiSamplingStarted = true;
                    this.startReservoirSamplingForStrati(this.assigner.getAllCreatedStrati());
                    return new WaitForSamplingStepEvent(this.getId());
                }
                if (!this.stratiSamplingFinished) {
                    if (this.executorService.isTerminated()) {
                        this.stratiSamplingFinished = true;
                    } else {
                        Thread.sleep(100L);
                    }
                    return new WaitForSamplingStepEvent(this.getId());
                }
                try {
                    for (int i = 0; i < this.sample.size(); ++i) {
                        this.outputFileWriter.write(this.sample.get(i) + "\n");
                    }
                    return this.terminate();
                }
                catch (IOException e) {
                    throw new AlgorithmException((Throwable)e, "Was not able to write datapoint into output file.");
                }
            }
            case INACTIVE: {
                if (this.streamedDatapoints < this.datapointAmount || !this.stratiSamplingStarted || !this.stratiSamplingFinished) {
                    throw new AlgorithmException("Expected sample size was not reached before termination");
                }
                return this.terminate();
            }
        }
        this.cleanUp();
        throw new IllegalStateException("Unknown algorithm state " + this.getState());
    }

    @Override
    protected void cleanUp() {
        this.executorService.shutdownNow();
        this.tempFileHandler.cleanUp();
    }

    private void startReservoirSamplingForStrati(Map<String, Integer> strati) {
        int[] sampleSizeForStrati = new int[strati.keySet().size()];
        int i = 0;
        for (Map.Entry<String, Integer> entry : strati.entrySet()) {
            sampleSizeForStrati[i] = Math.round((float)((double)this.sampleSize.intValue() * ((double)strati.get(entry.getKey()).intValue() / (double)this.datapointAmount)));
            ++i;
        }
        i = 0;
        for (Map.Entry<String, Integer> entry : strati.entrySet()) {
            int index = i++;
            this.executorService.execute(() -> {
                String outputFile = this.tempFileHandler.createTempFile();
                ReservoirSampling reservoirSampling = new ReservoirSampling(this.random, this.tempFileHandler.getTempFile((String)entry.getKey()));
                reservoirSampling.setSampleSize(sampleSizeForStrati[index]);
                try {
                    String line;
                    reservoirSampling.setOutputFileName(this.tempFileHandler.getTempFile(outputFile).getAbsolutePath());
                    reservoirSampling.call();
                    BufferedReader bufferedReader = this.tempFileHandler.getFileReaderForTempFile(outputFile);
                    ArffUtilities.skipWithReaderToDatapoints(bufferedReader);
                    while ((line = bufferedReader.readLine()) != null) {
                        if (line.trim().equals("") || line.trim().charAt(0) == '%') continue;
                        List<String> list = this.sample;
                        synchronized (list) {
                            this.sample.add(line);
                        }
                    }
                    return;
                }
                catch (Exception e) {
                    this.logger.error("Unexpected exception during reservoir sampling!", (Throwable)e);
                }
            });
        }
        this.executorService.shutdown();
    }
}

