/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory;

import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.ml.core.dataset.DatasetCreationException;
import ai.libs.jaicore.ml.core.dataset.INumericArrayInstance;
import ai.libs.jaicore.ml.core.dataset.IOrderedDataset;
import ai.libs.jaicore.ml.core.dataset.sampling.SampleElementAddedEvent;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ASamplingAlgorithm;
import java.util.Collection;
import java.util.Comparator;
import java.util.Random;

public class SystematicSampling<I extends INumericArrayInstance, D extends IOrderedDataset<I>>
extends ASamplingAlgorithm<I, D> {
    private Random random;
    private D sortedDataset = null;
    private int k;
    private int startIndex;
    private int index;
    private Comparator<I> datapointComparator = (o1, o2) -> {
        double[] v1 = o1.getPoint();
        double[] v2 = o2.getPoint();
        for (int i = 0; i < Math.min(v1.length, v2.length); ++i) {
            int c = Double.compare(v1[i], v2[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    };

    public SystematicSampling(Random random, D input) {
        super(input);
        this.random = random;
    }

    public SystematicSampling(Random random, Comparator<I> datapointComparator, D input) {
        this(random, input);
        this.datapointComparator = datapointComparator;
    }

    public AlgorithmEvent nextWithException() throws AlgorithmException {
        switch (this.getState()) {
            case CREATED: {
                try {
                    this.sample = (IOrderedDataset)((IOrderedDataset)this.getInput()).createEmpty();
                    if (this.sortedDataset == null) {
                        this.sortedDataset = (IOrderedDataset)((IOrderedDataset)this.getInput()).createEmpty();
                        this.sortedDataset.addAll((Collection)this.getInput());
                        this.sortedDataset.sort(this.datapointComparator);
                    }
                }
                catch (DatasetCreationException e) {
                    throw new AlgorithmException((Throwable)e, "Could not create a copy of the dataset.");
                }
                this.startIndex = this.random.nextInt(this.sortedDataset.size());
                this.k = this.sortedDataset.size() / this.sampleSize;
                this.index = 0;
                return this.activate();
            }
            case ACTIVE: {
                if (((IOrderedDataset)this.sample).size() < this.sampleSize) {
                    int e = (this.startIndex + this.index++ * this.k) % this.sortedDataset.size();
                    ((IOrderedDataset)this.sample).add((INumericArrayInstance)this.sortedDataset.get(e));
                    return new SampleElementAddedEvent(this.getId());
                }
                return this.terminate();
            }
            case INACTIVE: {
                this.doInactiveStep();
                break;
            }
            default: {
                throw new IllegalStateException("Unknown algorithm state " + this.getState());
            }
        }
        return null;
    }

    public D getSortedDataset() {
        return this.sortedDataset;
    }

    public void setSortedDataset(D sortedDataset) {
        this.sortedDataset = sortedDataset;
    }
}

