/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.sampling.inmemory.casecontrol;

import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.ml.core.dataset.IDataset;
import ai.libs.jaicore.ml.core.dataset.ILabeledAttributeArrayInstance;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.casecontrol.PilotEstimateSampling;
import ai.libs.jaicore.ml.core.dataset.weka.WekaInstance;
import java.util.ArrayList;
import java.util.Random;
import weka.classifiers.Classifier;
import weka.core.Instance;

public class OSMAC<I extends ILabeledAttributeArrayInstance<?>, D extends IDataset<I>>
extends PilotEstimateSampling<I, D> {
    public OSMAC(Random rand, int preSampleSize, D input) {
        super(input);
        this.rand = rand;
        this.preSampleSize = preSampleSize;
    }

    @Override
    protected ArrayList<Pair<I, Double>> calculateFinalInstanceBoundaries(D instances, Classifier pilotEstimator) {
        double loss;
        int vectorLength;
        Instance wekaInstance;
        double boundaryOfCurrentInstance = 0.0;
        ArrayList<Pair<I, Double>> probabilityBoundaries = new ArrayList<Pair<I, Double>>();
        ArrayList<Pair> instanceProbabilityBoundaries = new ArrayList<Pair>();
        double sumOfDistributionLosses = 0.0;
        for (ILabeledAttributeArrayInstance instance : instances) {
            wekaInstance = (Instance)((WekaInstance)instance).getElement();
            vectorLength = 0;
            for (double dimensionLength : wekaInstance.toDoubleArray()) {
                vectorLength = (int)((double)vectorLength + dimensionLength);
            }
            try {
                loss = 1.0 - pilotEstimator.distributionForInstance(wekaInstance)[(int)wekaInstance.classValue()];
            }
            catch (Exception e) {
                loss = 1.0;
            }
            sumOfDistributionLosses += loss * (double)vectorLength;
        }
        for (ILabeledAttributeArrayInstance instance : instances) {
            wekaInstance = (Instance)((WekaInstance)instance).getElement();
            vectorLength = 0;
            for (double dimensionLength : wekaInstance.toDoubleArray()) {
                vectorLength = (int)((double)vectorLength + dimensionLength);
            }
            try {
                loss = 1.0 - pilotEstimator.distributionForInstance(wekaInstance)[(int)wekaInstance.classValue()];
            }
            catch (Exception e) {
                loss = 1.0;
            }
            instanceProbabilityBoundaries.add(new Pair((Object)instance, (Object)(boundaryOfCurrentInstance += loss * (double)vectorLength / sumOfDistributionLosses)));
        }
        int iterator = 0;
        for (ILabeledAttributeArrayInstance instance : instances) {
            probabilityBoundaries.add(new Pair((Object)instance, (Object)((Double)((Pair)instanceProbabilityBoundaries.get(iterator)).getY())));
            ++iterator;
        }
        return probabilityBoundaries;
    }
}

