/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.dyadranking.algorithm;

import ai.libs.jaicore.ml.core.predictivemodel.IPredictiveModelConfiguration;
import java.util.List;
import org.aeonbits.owner.Config;

@Config.Sources(value={"file:conf/plNet/plnet.properties"})
public interface IPLNetDyadRankerConfiguration
extends IPredictiveModelConfiguration {
    public static final String K_PLNET_LEARNINGRATE = "plnet.learningrate";
    public static final String K_PLNET_HIDDEN_NODES = "plnet.hidden.nodes";
    public static final String K_PLNET_SEED = "plnet.seed";
    public static final String K_ACTIVATION_FUNCTION = "plnet.hidden.activation.function";
    public static final String K_MAX_EPOCHS = "plnet.epochs";
    public static final String K_MINI_BATCH_SIZE = "plnet.minibatch.size";
    public static final String K_EARLY_STOPPING_INTERVAL = "plnet.early.stopping.interval";
    public static final String K_EARLY_STOPPING_PATIENCE = "plnet.early.stopping.patience";
    public static final String K_EARLY_STOPPING_TRAIN_RATIO = "plnet.early.stopping.train.ratio";
    public static final String K_EARLY_STOPPING_RETRAIN = "plnet.early.stopping.retrain";

    @Config.Key(value="plnet.learningrate")
    @Config.DefaultValue(value="0.1")
    public double plNetLearningRate();

    @Config.Key(value="plnet.hidden.nodes")
    @Config.DefaultValue(value="8")
    public List<Integer> plNetHiddenNodes();

    @Config.Key(value="plnet.seed")
    @Config.DefaultValue(value="42")
    public int plNetSeed();

    @Config.Key(value="plnet.hidden.activation.function")
    @Config.DefaultValue(value="SIGMOID")
    public String plNetActivationFunction();

    @Config.Key(value="plnet.epochs")
    @Config.DefaultValue(value="25")
    public int plNetMaxEpochs();

    @Config.Key(value="plnet.minibatch.size")
    @Config.DefaultValue(value="4")
    public int plNetMiniBatchSize();

    @Config.Key(value="plnet.early.stopping.interval")
    @Config.DefaultValue(value="1")
    public int plNetEarlyStoppingInterval();

    @Config.Key(value="plnet.early.stopping.patience")
    @Config.DefaultValue(value="10")
    public int plNetEarlyStoppingPatience();

    @Config.Key(value="plnet.early.stopping.train.ratio")
    @Config.DefaultValue(value="0.8")
    public double plNetEarlyStoppingTrainRatio();

    @Config.Key(value="plnet.early.stopping.retrain")
    @Config.DefaultValue(value="true")
    public boolean plNetEarlyStoppingRetrain();
}

