/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.dyadranking.loss;

import ai.libs.jaicore.ml.dyadranking.Dyad;
import ai.libs.jaicore.ml.dyadranking.dataset.IDyadRankingInstance;
import ai.libs.jaicore.ml.dyadranking.loss.DyadRankingLossFunction;

public class KendallsTauDyadRankingLoss
implements DyadRankingLossFunction {
    @Override
    public double loss(IDyadRankingInstance actual, IDyadRankingInstance predicted) {
        int dyadRankingLength = actual.length();
        if (dyadRankingLength <= 1) {
            throw new IllegalArgumentException("Dyad rankings must have length greater than 1.");
        }
        int nConc = 0;
        int nDisc = 0;
        for (int predIndex = 0; predIndex < dyadRankingLength - 1; ++predIndex) {
            int i;
            Dyad predDyad = predicted.getDyadAtPosition(predIndex);
            int actualIndex = -1;
            for (i = 0; i < dyadRankingLength; ++i) {
                if (!actual.getDyadAtPosition(i).equals(predDyad)) continue;
                actualIndex = i;
                break;
            }
            for (i = predIndex + 1; i < dyadRankingLength; ++i) {
                if (this.isRankingCorrectForIndex(actual, predicted, dyadRankingLength, actualIndex, i)) {
                    ++nConc;
                    continue;
                }
                ++nDisc;
            }
        }
        return 2.0 * (double)(nConc - nDisc) / (double)(dyadRankingLength * (dyadRankingLength - 1));
    }

    private boolean isRankingCorrectForIndex(IDyadRankingInstance actual, IDyadRankingInstance predicted, int dyadRankingLength, int actualIndex, int i) {
        Dyad predPairedDyad = predicted.getDyadAtPosition(i);
        boolean found = false;
        for (int j = actualIndex + 1; j < dyadRankingLength && !found; ++j) {
            if (!actual.getDyadAtPosition(j).equals(predPairedDyad)) continue;
            found = true;
        }
        return found;
    }
}

