/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.evaluation.evaluators.weka;

import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ASamplingAlgorithm;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.ISamplingAlgorithmFactory;
import ai.libs.jaicore.ml.core.dataset.weka.WekaInstance;
import ai.libs.jaicore.ml.core.dataset.weka.WekaInstances;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.IClassifierEvaluator;
import ai.libs.jaicore.ml.interfaces.LearningCurve;
import ai.libs.jaicore.ml.learningcurve.extrapolation.ConfigurationLearningCurveExtrapolator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;

public class ConfigurationLearningCurveExtrapolationEvaluator
implements IClassifierEvaluator {
    private Logger logger = LoggerFactory.getLogger(ConfigurationLearningCurveExtrapolationEvaluator.class);
    private int[] anchorpoints;
    private ISamplingAlgorithmFactory<WekaInstance<Object>, WekaInstances<Object>, ASamplingAlgorithm<WekaInstance<Object>, WekaInstances<Object>>> samplingAlgorithmFactory;
    private WekaInstances<Object> dataset;
    private double trainSplitForAnchorpointsMeasurement;
    private long seed;
    private String identifier;
    private double[] configurations;
    private int fullDatasetSize = -1;

    public ConfigurationLearningCurveExtrapolationEvaluator(int[] anchorpoints, ISamplingAlgorithmFactory<WekaInstance<Object>, WekaInstances<Object>, ASamplingAlgorithm<WekaInstance<Object>, WekaInstances<Object>>> samplingAlgorithmFactory, WekaInstances<Object> dataset, double trainSplitForAnchorpointsMeasurement, long seed, String identifier, double[] configurations) {
        this.anchorpoints = anchorpoints;
        this.samplingAlgorithmFactory = samplingAlgorithmFactory;
        this.dataset = dataset;
        this.trainSplitForAnchorpointsMeasurement = trainSplitForAnchorpointsMeasurement;
        this.seed = seed;
        this.identifier = identifier;
        this.configurations = configurations;
    }

    public void setFullDatasetSize(int fullDatasetSize) {
        this.fullDatasetSize = fullDatasetSize;
    }

    public Double evaluate(Classifier classifier) throws InterruptedException, ObjectEvaluationFailedException {
        try {
            ConfigurationLearningCurveExtrapolator<WekaInstance<Object>, WekaInstances<Object>> extrapolator = new ConfigurationLearningCurveExtrapolator<WekaInstance<Object>, WekaInstances<Object>>(classifier, this.dataset, this.trainSplitForAnchorpointsMeasurement, this.anchorpoints, this.samplingAlgorithmFactory, this.seed, this.identifier, this.configurations);
            LearningCurve learningCurve = extrapolator.extrapolateLearningCurve();
            int evaluationPoint = this.dataset.size();
            if (this.fullDatasetSize != -1) {
                evaluationPoint = this.fullDatasetSize;
            }
            return learningCurve.getCurveValue(evaluationPoint) * 100.0;
        }
        catch (Exception e) {
            this.logger.warn("Evaluation of classifier failed due Exception {} with message {}. Returning null.", (Object)e.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }
}

