/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.evaluation.evaluators.weka;

import ai.libs.jaicore.basic.algorithm.AlgorithmExecutionCanceledException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmTimeoutedException;
import ai.libs.jaicore.basic.algorithm.exceptions.ObjectEvaluationFailedException;
import ai.libs.jaicore.ml.core.dataset.DatasetCreationException;
import ai.libs.jaicore.ml.core.dataset.ILabeledAttributeArrayInstance;
import ai.libs.jaicore.ml.core.dataset.IOrderedLabeledAttributeArrayDataset;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.ASamplingAlgorithm;
import ai.libs.jaicore.ml.core.dataset.sampling.inmemory.factories.interfaces.ISamplingAlgorithmFactory;
import ai.libs.jaicore.ml.core.dataset.weka.WekaInstances;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.FixedSplitClassifierEvaluator;
import ai.libs.jaicore.ml.evaluation.evaluators.weka.IClassifierEvaluator;
import ai.libs.jaicore.ml.interfaces.AnalyticalLearningCurve;
import ai.libs.jaicore.ml.learningcurve.extrapolation.InvalidAnchorPointsException;
import ai.libs.jaicore.ml.learningcurve.extrapolation.LearningCurveExtrapolationMethod;
import ai.libs.jaicore.ml.learningcurve.extrapolation.LearningCurveExtrapolator;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weka.classifiers.Classifier;
import weka.core.Instances;

public class ExtrapolatedSaturationPointEvaluator<I extends ILabeledAttributeArrayInstance<?>, D extends IOrderedLabeledAttributeArrayDataset<I, ?>>
implements IClassifierEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(ExtrapolatedSaturationPointEvaluator.class);
    private static final double DEFAULT_EPSILON = 0.1;
    private int[] anchorpoints;
    private ISamplingAlgorithmFactory<I, D, ? extends ASamplingAlgorithm<I, D>> samplingAlgorithmFactory;
    private D train;
    private double trainSplitForAnchorpointsMeasurement;
    private LearningCurveExtrapolationMethod extrapolationMethod;
    private long seed;
    private double epsilon;
    private D test;

    public ExtrapolatedSaturationPointEvaluator(int[] anchorpoints, ISamplingAlgorithmFactory<I, D, ? extends ASamplingAlgorithm<I, D>> samplingAlgorithmFactory, D train, double trainSplitForAnchorpointsMeasurement, LearningCurveExtrapolationMethod extrapolationMethod, long seed, D test) {
        this.anchorpoints = anchorpoints;
        this.samplingAlgorithmFactory = samplingAlgorithmFactory;
        this.train = train;
        this.trainSplitForAnchorpointsMeasurement = trainSplitForAnchorpointsMeasurement;
        this.extrapolationMethod = extrapolationMethod;
        this.seed = seed;
        this.epsilon = 0.1;
        this.test = test;
    }

    public void setEpsilon(double epsilon) {
        this.epsilon = epsilon;
    }

    public Double evaluate(Classifier classifier) throws InterruptedException, ObjectEvaluationFailedException {
        try {
            LearningCurveExtrapolator<I, D> extrapolator = new LearningCurveExtrapolator<I, D>(this.extrapolationMethod, classifier, this.train, this.trainSplitForAnchorpointsMeasurement, this.anchorpoints, this.samplingAlgorithmFactory, this.seed);
            AnalyticalLearningCurve learningCurve = (AnalyticalLearningCurve)extrapolator.extrapolateLearningCurve();
            int optimalSampleSize = Math.min(this.train.size(), (int)learningCurve.getSaturationPoint(this.epsilon));
            ASamplingAlgorithm<I, D> samplingAlgorithm = this.samplingAlgorithmFactory.getAlgorithm(optimalSampleSize, this.train, new Random(this.seed));
            IOrderedLabeledAttributeArrayDataset saturationPointTrainSet = (IOrderedLabeledAttributeArrayDataset)samplingAlgorithm.call();
            Instances saturationPointInstances = (Instances)((WekaInstances)saturationPointTrainSet).getList();
            Instances testInstances = (Instances)((WekaInstances)this.test).getList();
            FixedSplitClassifierEvaluator evaluator = new FixedSplitClassifierEvaluator(saturationPointInstances, testInstances);
            return evaluator.evaluate(classifier);
        }
        catch (AlgorithmExecutionCanceledException | AlgorithmException | AlgorithmTimeoutedException | DatasetCreationException | InvalidAnchorPointsException e) {
            logger.warn("Evaluation of classifier failed due Exception {} with message {}. Returning null.", (Object)e.getClass().getName(), (Object)e.getMessage());
            return null;
        }
    }
}

