/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.ranking.clusterbased.modifiedisac;

import ai.libs.jaicore.ml.ranking.clusterbased.modifiedisac.IDistanceMetric;
import ai.libs.jaicore.ml.ranking.clusterbased.modifiedisac.Kmeans;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModifiedISACkMeans
extends Kmeans<double[], Double> {
    private Map<double[], Integer> positionOfPointInList = new HashMap<double[], Integer>();
    private Map<double[], List<double[]>> pointsInCenter = new HashMap<double[], List<double[]>>();
    private Map<double[], double[]> centerOfPoint = new HashMap<double[], double[]>();
    private List<double[]> initpoints = new ArrayList<double[]>();

    public ModifiedISACkMeans(List<double[]> toClusterPoints, IDistanceMetric<Double, double[], double[]> dist) {
        super(toClusterPoints, dist);
        for (int i = 0; i < toClusterPoints.size(); ++i) {
            this.positionOfPointInList.put(toClusterPoints.get(i), i);
        }
        this.initpoints = new ArrayList<double[]>(toClusterPoints);
    }

    @Override
    public Map<double[], List<double[]>> kmeanscluster(int k) {
        this.k = k;
        this.initializeKMeans();
        boolean test = true;
        while (test) {
            this.relocateCenter();
            test = this.relocatePoints();
        }
        return this.pointsInCenter;
    }

    @Override
    public void initializeKMeans() {
        this.initializeFirstCenter();
        this.initializeFollowingCenter();
        this.locateFirstPoints();
    }

    private void initializeFirstCenter() {
        double[] firstCenter = new double[((double[])this.points.get(0)).length];
        for (int i = 0; i < ((double[])this.points.get(0)).length; ++i) {
            int totalvalue = this.points.size();
            for (double[] d : this.points) {
                if (Double.isNaN(d[i])) {
                    --totalvalue;
                    continue;
                }
                int n = i;
                firstCenter[n] = firstCenter[n] + d[i];
            }
            firstCenter[i] = firstCenter[i] / (double)totalvalue;
        }
        this.center.add(firstCenter);
        this.pointsInCenter.put(firstCenter, new ArrayList());
    }

    private void locateFirstPoints() {
        for (double[] point : this.points) {
            int indexOfMyCenter = 0;
            double maxCenterDist = (Double)this.metric.computeDistance(point, (double[])this.center.get(0));
            for (int i = 1; i < this.center.size(); ++i) {
                double tmp = (Double)this.metric.computeDistance(point, (double[])this.center.get(i));
                if (!(tmp <= maxCenterDist)) continue;
                indexOfMyCenter = i;
                maxCenterDist = tmp;
            }
            this.centerOfPoint.put(point, (double[])this.center.get(indexOfMyCenter));
            this.pointsInCenter.get(this.center.get(indexOfMyCenter)).add(point);
        }
    }

    private boolean relocatePoints() {
        boolean hasSomethingChanged = false;
        for (double[] c : this.center) {
            this.pointsInCenter.get(c).clear();
        }
        for (double[] point : this.points) {
            double minDist = (Double)this.metric.computeDistance(point, (double[])this.center.get(0));
            int indexOfMyCenter = 0;
            for (int i = 1; i < this.center.size(); ++i) {
                double tmp = (Double)this.metric.computeDistance(point, (double[])this.center.get(i));
                if (!(tmp < minDist)) continue;
                indexOfMyCenter = i;
                minDist = tmp;
            }
            if (!Arrays.equals(this.centerOfPoint.get(point), (double[])this.center.get(indexOfMyCenter))) {
                hasSomethingChanged = true;
                this.centerOfPoint.replace(point, (double[])this.center.get(indexOfMyCenter));
            }
            this.pointsInCenter.get(this.center.get(indexOfMyCenter)).add(point);
        }
        return hasSomethingChanged;
    }

    private void relocateCenter() {
        for (int i = 0; i < this.center.size(); ++i) {
            int size = ((double[])this.center.get(i)).length;
            double[] sumarray = new double[size];
            double[] totalvalue = new double[size];
            if (!this.pointsInCenter.get(this.center.get(i)).isEmpty()) {
                for (double[] d : this.pointsInCenter.get(this.center.get(i))) {
                    for (int j = 0; j < d.length; ++j) {
                        if (Double.isNaN(d[j])) continue;
                        int n = j;
                        sumarray[n] = sumarray[n] + d[j];
                        int n2 = j;
                        totalvalue[n2] = totalvalue[n2] + 1.0;
                    }
                }
                for (int l = 0; l < sumarray.length; ++l) {
                    if (Double.isNaN(sumarray[l])) {
                        sumarray[l] = 0.0;
                        continue;
                    }
                    if (sumarray[l] != 0.0 && totalvalue[l] != 0.0) {
                        sumarray[l] = sumarray[l] / totalvalue[l];
                        continue;
                    }
                    if (totalvalue[l] != 0.0) continue;
                    sumarray[l] = Double.NaN;
                }
            }
            List<double[]> myPoints = this.pointsInCenter.remove(this.center.get(i));
            this.pointsInCenter.put(sumarray, myPoints);
            this.center.set(i, sumarray);
        }
    }

    private void initializeFollowingCenter() {
        for (int i = 1; i < this.k; ++i) {
            double maxsum = 0.0;
            int indexOfnewCenter = 0;
            int indexofnewCenterinInit = 0;
            for (int j = 0; j < this.initpoints.size(); ++j) {
                double tmp = 0.0;
                for (double[] c : this.center) {
                    tmp += ((Double)this.metric.computeDistance(this.initpoints.get(j), c)).doubleValue();
                }
                if (!(tmp >= maxsum)) continue;
                maxsum = tmp;
                indexOfnewCenter = this.positionOfPointInList.get(this.initpoints.get(j));
                indexofnewCenterinInit = j;
            }
            this.initpoints.remove(indexofnewCenterinInit);
            this.center.add((double[])this.points.get(indexOfnewCenter));
            this.pointsInCenter.put((double[])this.points.get(indexOfnewCenter), new ArrayList());
        }
    }

    public List<double[]> getCenter() {
        return this.center;
    }
}

