/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.classifier;

import ai.libs.jaicore.ml.core.exception.PredictionException;
import ai.libs.jaicore.ml.core.exception.TrainingException;
import ai.libs.jaicore.ml.tsc.classifier.ASimplifiedTSCLearningAlgorithm;
import ai.libs.jaicore.ml.tsc.dataset.TimeSeriesDataset;
import ai.libs.jaicore.ml.tsc.util.ClassMapper;
import java.util.List;

public abstract class ASimplifiedTSClassifier<T> {
    protected ClassMapper classMapper;
    protected boolean trained;

    public abstract T predict(double[] var1) throws PredictionException;

    public T predict(List<double[]> multivInstance) throws PredictionException {
        throw new PredictionException("Can't predict on multivariate data yet.");
    }

    public abstract List<T> predict(TimeSeriesDataset var1) throws PredictionException;

    public abstract <U extends ASimplifiedTSClassifier<T>> ASimplifiedTSCLearningAlgorithm<T, U> getLearningAlgorithm(TimeSeriesDataset var1);

    public final void train(TimeSeriesDataset dataset) throws TrainingException {
        ASimplifiedTSCLearningAlgorithm algorithm = this.getLearningAlgorithm(dataset);
        try {
            algorithm.call();
            this.trained = true;
        }
        catch (Exception e) {
            throw new TrainingException("Could not train model " + this.getClass().getSimpleName(), e);
        }
    }

    public ClassMapper getClassMapper() {
        return this.classMapper;
    }

    public void setClassMapper(ClassMapper classMapper) {
        this.classMapper = classMapper;
    }

    public boolean isTrained() {
        return this.trained;
    }

    protected double[][] checkWhetherPredictionIsPossible(TimeSeriesDataset dataset) throws PredictionException {
        if (!this.isTrained()) {
            throw new PredictionException("Model has not been built before!");
        }
        if (dataset == null || dataset.isEmpty()) {
            throw new IllegalArgumentException("Dataset to be predicted must not be null or empty!");
        }
        double[][] testInstances = dataset.getValuesOrNull(0);
        if (testInstances == null) {
            throw new PredictionException("Can't predict on empty dataset.");
        }
        return testInstances;
    }
}

