/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.classifier;

import ai.libs.jaicore.basic.algorithm.IAlgorithmConfig;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.ml.tsc.HistogramBuilder;
import ai.libs.jaicore.ml.tsc.classifier.ASimplifiedTSCLearningAlgorithm;
import ai.libs.jaicore.ml.tsc.classifier.BOSSClassifier;
import ai.libs.jaicore.ml.tsc.dataset.TimeSeriesDataset;
import ai.libs.jaicore.ml.tsc.filter.SFA;
import ai.libs.jaicore.ml.tsc.filter.SlidingWindowBuilder;
import ai.libs.jaicore.ml.tsc.filter.ZTransformer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aeonbits.owner.Config;

public class BOSSLearningAlgorithm
extends ASimplifiedTSCLearningAlgorithm<Integer, BOSSClassifier> {
    private List<ArrayList<HashMap<Integer, Integer>>> multivirateHistograms = new ArrayList<ArrayList<HashMap<Integer, Integer>>>();
    private ArrayList<HashMap<Integer, Integer>> histograms = new ArrayList();

    public BOSSLearningAlgorithm(IBossAlgorithmConfig config, BOSSClassifier classifier, TimeSeriesDataset data) {
        super(config, classifier, data);
    }

    @Override
    public AlgorithmEvent nextWithException() {
        return null;
    }

    public BOSSClassifier call() {
        this.multivirateHistograms.clear();
        IBossAlgorithmConfig config = (IBossAlgorithmConfig)this.getConfig();
        HistogramBuilder histoBuilder = new HistogramBuilder();
        SFA sfa = new SFA(config.alphabet(), config.wordLength());
        SlidingWindowBuilder slide = new SlidingWindowBuilder();
        slide.setDefaultWindowSize(config.windowSize());
        TimeSeriesDataset data = (TimeSeriesDataset)this.getInput();
        for (int matrix = 0; matrix < data.getNumberOfVariables(); ++matrix) {
            this.histograms.clear();
            for (int instance = 0; instance < data.getNumberOfInstances(); ++instance) {
                TimeSeriesDataset tmp = slide.specialFitTransform(data.getValues(matrix)[instance]);
                ZTransformer znorm = new ZTransformer();
                for (int i = 0; i < tmp.getValues(0).length; ++i) {
                    tmp.getValues((int)0)[i] = znorm.fitTransform(tmp.getValues(0)[i]);
                }
                TimeSeriesDataset tmpTransformed = sfa.fitTransform(tmp);
                Map<Integer, Integer> histogram = histoBuilder.histogramForInstance(tmpTransformed);
                this.histograms.add(new HashMap<Integer, Integer>(histogram));
            }
            this.multivirateHistograms.add(this.histograms);
        }
        BOSSClassifier model = (BOSSClassifier)this.getClassifier();
        model.setTrainingData((TimeSeriesDataset)this.getInput());
        return model;
    }

    public static interface IBossAlgorithmConfig
    extends IAlgorithmConfig {
        public static final String K_WINDOW_SIZE = "boss.windowsize";
        public static final String K_ALPHABET_SIZE = "boss.alphabetsize";
        public static final String K_ALPHABET = "boss.alphabet";
        public static final String K_WORDLENGTH = "boss.wordlength";
        public static final String K_MEANCORRECTED = "boss.meancorrected";

        @Config.Key(value="boss.windowsize")
        public int windowSize();

        @Config.Key(value="boss.alphabetsize")
        @Config.DefaultValue(value="4")
        public int alphabetSize();

        @Config.Key(value="boss.alphabet")
        public double[] alphabet();

        @Config.Key(value="boss.wordlength")
        public int wordLength();

        @Config.Key(value="boss.meancorrected")
        public boolean meanCorrected();
    }
}

