/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.classifier.ensemble;

import ai.libs.jaicore.ml.tsc.classifier.ensemble.MajorityConfidenceVote;
import weka.classifiers.Classifier;
import weka.classifiers.bayes.NaiveBayes;
import weka.classifiers.functions.Logistic;
import weka.classifiers.functions.MultilayerPerceptron;
import weka.classifiers.functions.SMO;
import weka.classifiers.functions.supportVector.Kernel;
import weka.classifiers.functions.supportVector.PolyKernel;
import weka.classifiers.lazy.IBk;
import weka.classifiers.meta.RotationForest;
import weka.classifiers.trees.J48;
import weka.classifiers.trees.RandomForest;
import weka.core.DistanceFunction;
import weka.core.EuclideanDistance;

public class EnsembleProvider {
    private EnsembleProvider() {
    }

    public static Classifier provideCAWPEEnsembleModel(int seed, int numFolds) throws Exception {
        Classifier[] classifiers = new Classifier[5];
        MajorityConfidenceVote voter = new MajorityConfidenceVote(numFolds, seed);
        SMO smo = new SMO();
        smo.turnChecksOff();
        smo.setBuildCalibrationModels(true);
        PolyKernel kl = new PolyKernel();
        kl.setExponent(1.0);
        smo.setKernel((Kernel)kl);
        smo.setRandomSeed(seed);
        classifiers[0] = smo;
        IBk k = new IBk(100);
        k.setCrossValidate(true);
        EuclideanDistance ed = new EuclideanDistance();
        ed.setDontNormalize(true);
        k.getNearestNeighbourSearchAlgorithm().setDistanceFunction((DistanceFunction)ed);
        classifiers[1] = k;
        J48 c45 = new J48();
        c45.setSeed(seed);
        classifiers[2] = c45;
        classifiers[3] = new Logistic();
        classifiers[4] = new MultilayerPerceptron();
        voter.setClassifiers(classifiers);
        return voter;
    }

    public static Classifier provideHIVECOTEEnsembleModel(int seed, int numFolds) {
        Classifier[] classifier = new Classifier[7];
        MajorityConfidenceVote voter = new MajorityConfidenceVote(5, seed);
        SMO smop = new SMO();
        smop.turnChecksOff();
        smop.setBuildCalibrationModels(true);
        PolyKernel kernel = new PolyKernel();
        kernel.setExponent(2.0);
        smop.setKernel((Kernel)kernel);
        smop.setRandomSeed(seed);
        classifier[0] = smop;
        RandomForest rf = new RandomForest();
        rf.setSeed(seed);
        rf.setNumIterations(500);
        classifier[1] = rf;
        RotationForest rotF = new RotationForest();
        rotF.setSeed(seed);
        rotF.setNumIterations(100);
        classifier[2] = rotF;
        IBk nn = new IBk();
        classifier[3] = nn;
        NaiveBayes nb = new NaiveBayes();
        classifier[4] = nb;
        J48 c45 = new J48();
        c45.setSeed(seed);
        classifier[5] = c45;
        SMO smol = new SMO();
        smol.turnChecksOff();
        smol.setBuildCalibrationModels(true);
        PolyKernel linearKernel = new PolyKernel();
        linearKernel.setExponent(1.0);
        smol.setKernel((Kernel)linearKernel);
        classifier[6] = smol;
        voter.setClassifiers(classifier);
        return voter;
    }
}

