/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.classifier.neighbors;

import ai.libs.jaicore.basic.algorithm.IAlgorithmConfig;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.ml.tsc.classifier.ASimplifiedTSCLearningAlgorithm;
import ai.libs.jaicore.ml.tsc.classifier.neighbors.NearestNeighborClassifier;
import ai.libs.jaicore.ml.tsc.dataset.TimeSeriesDataset;

public class NearestNeighborLearningAlgorithm
extends ASimplifiedTSCLearningAlgorithm<Integer, NearestNeighborClassifier> {
    protected NearestNeighborLearningAlgorithm(IAlgorithmConfig config, NearestNeighborClassifier classifier, TimeSeriesDataset input) {
        super(config, classifier, input);
    }

    public NearestNeighborClassifier call() throws AlgorithmException {
        TimeSeriesDataset dataset = (TimeSeriesDataset)this.getInput();
        if (dataset == null) {
            throw new AlgorithmException("No input data set.");
        }
        if (dataset.isMultivariate()) {
            throw new UnsupportedOperationException("Multivariate datasets are not supported.");
        }
        double[][] values = dataset.getValuesOrNull(0);
        if (values == null) {
            throw new AlgorithmException("Empty input data set.");
        }
        int[] targets = dataset.getTargets();
        if (targets == null) {
            throw new AlgorithmException("Empty targets.");
        }
        NearestNeighborClassifier model = (NearestNeighborClassifier)this.getClassifier();
        model.setValues(values);
        model.setTimestamps(dataset.getTimestampsOrNull(0));
        model.setTargets(targets);
        return model;
    }

    @Override
    public AlgorithmEvent nextWithException() {
        throw new UnsupportedOperationException();
    }
}

