/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.classifier.neighbors;

import ai.libs.jaicore.basic.algorithm.IAlgorithmConfig;
import ai.libs.jaicore.basic.algorithm.events.AlgorithmEvent;
import ai.libs.jaicore.basic.algorithm.exceptions.AlgorithmException;
import ai.libs.jaicore.basic.sets.Pair;
import ai.libs.jaicore.ml.tsc.classifier.ASimplifiedTSCLearningAlgorithm;
import ai.libs.jaicore.ml.tsc.classifier.neighbors.NearestNeighborClassifier;
import ai.libs.jaicore.ml.tsc.classifier.neighbors.ShotgunEnsembleClassifier;
import ai.libs.jaicore.ml.tsc.dataset.TimeSeriesDataset;
import ai.libs.jaicore.ml.tsc.distances.ShotgunDistance;
import java.util.ArrayList;
import org.aeonbits.owner.Config;

public class ShotgunEnsembleLearnerAlgorithm
extends ASimplifiedTSCLearningAlgorithm<Integer, ShotgunEnsembleClassifier> {
    public ShotgunEnsembleLearnerAlgorithm(IShotgunEnsembleLearnerConfig config, ShotgunEnsembleClassifier classifier, TimeSeriesDataset dataset) {
        super(config, classifier, dataset);
    }

    @Override
    public AlgorithmEvent nextWithException() {
        throw new UnsupportedOperationException();
    }

    public IShotgunEnsembleLearnerConfig getConfig() {
        return (IShotgunEnsembleLearnerConfig)super.getConfig();
    }

    public ShotgunEnsembleClassifier call() throws AlgorithmException {
        TimeSeriesDataset dataset = (TimeSeriesDataset)this.getInput();
        if (dataset == null) {
            throw new AlgorithmException("No input data set.");
        }
        if (dataset.isMultivariate()) {
            throw new UnsupportedOperationException("Multivariate datasets are not supported.");
        }
        double[][] values = dataset.getValuesOrNull(0);
        if (values == null) {
            throw new AlgorithmException("Empty input data set.");
        }
        int[] targets = dataset.getTargets();
        if (targets == null) {
            throw new AlgorithmException("Empty targets.");
        }
        ArrayList<Pair<Integer, Integer>> scores = new ArrayList<Pair<Integer, Integer>>();
        for (int windowLength = this.getConfig().windowSizeMax(); windowLength >= this.getConfig().windowSizeMin(); --windowLength) {
            int correct = 0;
            ShotgunDistance shotgunDistance = new ShotgunDistance(windowLength, this.getConfig().meanNormalization());
            for (int i = 0; i < values.length; ++i) {
                double minDistance = Double.MAX_VALUE;
                int instanceThatMinimizesDistance = -1;
                for (int j = 0; j < values.length; ++j) {
                    double distance;
                    if (i == j || !((distance = shotgunDistance.distance(values[i], values[j])) < minDistance)) continue;
                    minDistance = distance;
                    instanceThatMinimizesDistance = j;
                }
                if (targets[i] != targets[instanceThatMinimizesDistance]) continue;
                ++correct;
            }
            scores.add(new Pair((Object)correct, (Object)windowLength));
        }
        NearestNeighborClassifier nearestNeighborClassifier = new NearestNeighborClassifier(new ShotgunDistance(this.getConfig().windowSizeMax(), this.getConfig().meanNormalization()));
        try {
            nearestNeighborClassifier.train(dataset);
        }
        catch (Exception e) {
            throw new AlgorithmException((Throwable)e, "Cant train nearest neighbor classifier.");
        }
        ShotgunEnsembleClassifier model = (ShotgunEnsembleClassifier)this.getClassifier();
        model.setWindows(scores);
        model.setNearestNeighborClassifier(nearestNeighborClassifier);
        return model;
    }

    public static interface IShotgunEnsembleLearnerConfig
    extends IAlgorithmConfig {
        public static final String K_WINDOWLENGTH_MIN = "windowlength.min";
        public static final String K_WINDOWLENGTH_MAX = "windowlength.max";
        public static final String K_MEANNORMALIZATION = "meannormalization";

        @Config.Key(value="windowlength.min")
        public int windowSizeMin();

        @Config.Key(value="windowlength.max")
        public int windowSizeMax();

        @Config.Key(value="meannormalization")
        @Config.DefaultValue(value="false")
        public boolean meanNormalization();
    }
}

