/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.dataset;

import java.util.List;

public class TimeSeriesDataset {
    private int numberOfInstances;
    private List<double[][]> valueMatrices;
    private List<double[][]> timestampMatrices;
    private int[] targets;
    private final boolean train;

    public TimeSeriesDataset(List<double[][]> valueMatrices, List<double[][]> timestampMatrices, int[] targets) {
        this.numberOfInstances = valueMatrices.get(0).length;
        this.valueMatrices = valueMatrices;
        this.timestampMatrices = timestampMatrices;
        this.targets = targets;
        this.train = true;
    }

    public TimeSeriesDataset(List<double[][]> valueMatrices, List<double[][]> timestampMatrices) {
        this.numberOfInstances = valueMatrices.get(0).length;
        this.valueMatrices = valueMatrices;
        this.timestampMatrices = timestampMatrices;
        this.targets = new int[this.numberOfInstances];
        this.train = false;
    }

    public TimeSeriesDataset(List<double[][]> valueMatrices, int[] targets) {
        this(valueMatrices, null, targets);
    }

    public TimeSeriesDataset(List<double[][]> valueMatrices) {
        this.numberOfInstances = valueMatrices.get(0).length;
        this.valueMatrices = valueMatrices;
        this.timestampMatrices = null;
        this.targets = new int[this.numberOfInstances];
        this.train = false;
    }

    public void add(double[][] valueMatrix, double[][] timestampMatrix) {
        this.valueMatrices.add(valueMatrix);
        this.timestampMatrices.add(timestampMatrix);
    }

    public void add(double[][] valueMatrix) {
        this.valueMatrices.add(valueMatrix);
        this.timestampMatrices.add(null);
    }

    public void remove(int index) {
        this.valueMatrices.remove(index);
        this.timestampMatrices.remove(index);
    }

    public void replace(int index, double[][] valueMatrix, double[][] timestampMatrix) {
        this.valueMatrices.set(index, valueMatrix);
        if (timestampMatrix != null && this.timestampMatrices != null && this.timestampMatrices.size() > index) {
            this.timestampMatrices.set(index, timestampMatrix);
        }
    }

    public int[] getTargets() {
        return this.targets;
    }

    public int getNumberOfVariables() {
        return this.valueMatrices.size();
    }

    public int getNumberOfInstances() {
        return this.numberOfInstances;
    }

    public double[][] getValues(int index) {
        return this.valueMatrices.get(index);
    }

    public double[][] getTimestamps(int index) {
        return this.timestampMatrices.get(index);
    }

    public double[][] getValuesOrNull(int index) {
        return this.valueMatrices.size() > index ? this.valueMatrices.get(index) : null;
    }

    public double[][] getTimestampsOrNull(int index) {
        return this.timestampMatrices.size() > index ? this.timestampMatrices.get(index) : null;
    }

    public boolean isEmpty() {
        return this.valueMatrices.isEmpty();
    }

    public boolean isUnivariate() {
        return this.valueMatrices.size() == 1;
    }

    public boolean isMultivariate() {
        return this.valueMatrices.size() > 1;
    }

    public boolean isTrain() {
        return this.train;
    }

    public boolean isTest() {
        return !this.train;
    }

    public List<double[][]> getValueMatrices() {
        return this.valueMatrices;
    }

    public List<double[][]> getTimestampMatrices() {
        return this.timestampMatrices;
    }

    public void setValueMatrices(List<double[][]> valueMatrices) {
        this.valueMatrices = valueMatrices;
    }

    public void setTimestampMatrices(List<double[][]> timestampMatrices) {
        this.timestampMatrices = timestampMatrices;
    }

    public void setTargets(int[] targets) {
        this.targets = targets;
    }
}

