/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.distances;

import ai.libs.jaicore.ml.tsc.distances.ITimeSeriesDistance;

public abstract class AWeightedTrigometricDistance
implements ITimeSeriesDistance {
    private double alpha;
    private double a;
    private double b;

    public AWeightedTrigometricDistance(double alpha) {
        if (alpha > 1.5707963267948966 || alpha < 0.0) {
            throw new IllegalArgumentException("Parameter alpha has to be between 0 (inclusive) and pi/2 (inclusive).");
        }
        this.alpha = alpha;
    }

    public void setAlpha(double alpha) {
        if (alpha > 1.5707963267948966 || alpha < 0.0) {
            throw new IllegalArgumentException("Parameter alpha has to be between 0 (inclusive) and pi/2 (inclusive).");
        }
        this.alpha = alpha;
        this.a = Math.cos(alpha);
        this.b = Math.sin(alpha);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }
}

