/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.distances;

import ai.libs.jaicore.ml.tsc.distances.EuclideanDistance;
import ai.libs.jaicore.ml.tsc.distances.ITimeSeriesDistance;
import ai.libs.jaicore.ml.tsc.util.TimeSeriesUtil;
import java.util.Arrays;

public class ShotgunDistance
implements ITimeSeriesDistance {
    private int windowLength;
    private boolean meanNormalization;
    private EuclideanDistance euclideanDistance = new EuclideanDistance();

    public ShotgunDistance(int windowLength, boolean meanNormalization) {
        if (windowLength <= 0) {
            throw new IllegalArgumentException("The window length must not be less or equal to zero.");
        }
        this.windowLength = windowLength;
        this.meanNormalization = meanNormalization;
    }

    @Override
    public double distance(double[] a, double[] b) {
        double totalDistance = 0.0;
        int numberOfDisjointWindows = a.length / this.windowLength;
        for (int i = 0; i < numberOfDisjointWindows; ++i) {
            int startOfDisjointWindow = i * this.windowLength;
            double[] disjointWindow = Arrays.copyOfRange(a, startOfDisjointWindow, startOfDisjointWindow + this.windowLength);
            disjointWindow = this.meanNormalization ? TimeSeriesUtil.zTransform(disjointWindow) : TimeSeriesUtil.normalizeByStandardDeviation(disjointWindow);
            double windowDistance = Double.MAX_VALUE;
            int numberOfSlidingWindows = b.length - this.windowLength + 1;
            for (int j = 0; j < numberOfSlidingWindows; ++j) {
                int startOfSlidingWindow = j;
                double[] slidingWindow = Arrays.copyOfRange(b, startOfSlidingWindow, startOfSlidingWindow + this.windowLength);
                slidingWindow = this.meanNormalization ? TimeSeriesUtil.zTransform(slidingWindow) : TimeSeriesUtil.normalizeByStandardDeviation(slidingWindow);
                double distanceDisjointSliding = this.euclideanDistance.distance(disjointWindow, slidingWindow);
                if (!(distanceDisjointSliding < windowDistance)) continue;
                windowDistance = distanceDisjointSliding;
            }
            totalDistance += windowDistance;
        }
        return totalDistance;
    }

    public void setWindowLength(int windowLength) {
        this.windowLength = windowLength;
    }
}

