/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.features;

import ai.libs.jaicore.ml.tsc.util.MathUtil;

public class TimeSeriesFeature {
    public static final int NUM_FEATURE_TYPES = FeatureType.values().length;

    public static double[] getFeatures(double[] vector, int t1, int t2, boolean useBiasCorrection) {
        double[] result = new double[NUM_FEATURE_TYPES];
        if (t1 >= vector.length || t2 >= vector.length) {
            throw new IllegalArgumentException("Parameters t1 and t2 must be valid indices of the vector.");
        }
        if (t1 == t2) {
            return new double[]{vector[t1], 0.0, 0.0};
        }
        double xx = 0.0;
        double x = 0.0;
        double xy = 0.0;
        double y = 0.0;
        double yy = 0.0;
        for (int i = t1; i <= t2; ++i) {
            x += (double)i;
            y += vector[i];
            yy += vector[i] * vector[i];
            xx += (double)(i * i);
            xy += (double)i * vector[i];
        }
        double length = (double)(t2 - t1) + 1.0;
        result[0] = y / length;
        double stddev = yy / length - y / length * (y / length);
        if (useBiasCorrection) {
            stddev *= length / (length - 1.0);
        }
        result[1] = stddev = Math.sqrt(stddev);
        double divisor = length * xx - x * x;
        if (divisor == 0.0) {
            throw new IllegalStateException("Divisor is 0, which must not happen!");
        }
        result[2] = (length * xy - x * y) / divisor;
        return result;
    }

    public static double calculateFeature(FeatureType fType, double[] vector, int t1, int t2, boolean useBiasCorrection) {
        switch (fType) {
            case MEAN: {
                return MathUtil.mean(vector, t1, t2);
            }
            case STDDEV: {
                return MathUtil.stddev(vector, t1, t2, useBiasCorrection);
            }
            case SLOPE: {
                return MathUtil.slope(vector, t1, t2);
            }
        }
        throw new UnsupportedOperationException("Feature calculation function with id '" + (Object)((Object)fType) + "' is unknwon.");
    }

    public static enum FeatureType {
        MEAN,
        STDDEV,
        SLOPE;

    }
}

