/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.filter;

import ai.libs.jaicore.ml.tsc.dataset.TimeSeriesDataset;
import ai.libs.jaicore.ml.tsc.exceptions.NoneFittedFilterExeception;
import ai.libs.jaicore.ml.tsc.filter.IFilter;
import java.util.ArrayList;
import java.util.Arrays;

public class SlidingWindowBuilder
implements IFilter {
    private static final String MSG_SPECIALFIT = "This is done by the special fit and transform because this mehtod must return a new dataset not a double array.";
    private boolean fitted = false;
    private boolean fittedMatrix = false;
    private int defaultWindowSize = 20;
    private ArrayList<double[][]> blownUpDataset = new ArrayList();
    private double[][] blownUpMatrix = null;

    public void setDefaultWindowSize(int defaultWindowSize) {
        this.defaultWindowSize = defaultWindowSize;
    }

    public int getDefaultWindowSize() {
        return this.defaultWindowSize;
    }

    @Override
    public TimeSeriesDataset transform(TimeSeriesDataset input) {
        if (input.isEmpty()) {
            throw new IllegalArgumentException("The input dataset can not be empty");
        }
        if (!this.fitted) {
            throw new NoneFittedFilterExeception("The fit mehtod must be called before transformning");
        }
        return new TimeSeriesDataset(this.blownUpDataset, null, null);
    }

    @Override
    public void fit(TimeSeriesDataset input) {
        for (int matrix = 0; matrix < input.getNumberOfVariables(); ++matrix) {
            ArrayList<double[][]> newMatrices = new ArrayList<double[][]>();
            for (double[] instance : input.getValues(matrix)) {
                double[][] newMatrix = new double[instance.length - this.defaultWindowSize][this.defaultWindowSize];
                for (int entry = 0; entry < instance.length - this.defaultWindowSize; ++entry) {
                    double[] tmp = Arrays.copyOfRange(instance, entry, entry + this.defaultWindowSize);
                    newMatrix[entry] = tmp;
                }
                newMatrices.add(newMatrix);
            }
            this.blownUpDataset = newMatrices;
        }
        this.fitted = true;
    }

    public TimeSeriesDataset specialFitTransform(double[] instance) {
        if (instance.length == 0) {
            throw new IllegalArgumentException("The input instance can not be empty");
        }
        if (instance.length < this.defaultWindowSize) {
            throw new IllegalArgumentException("The input instance can not be smaller than the windowsize");
        }
        double[][] newMatrix = new double[instance.length - this.defaultWindowSize + 1][this.defaultWindowSize];
        for (int entry = 0; entry <= instance.length - this.defaultWindowSize; ++entry) {
            newMatrix[entry] = Arrays.copyOfRange(instance, entry, entry + this.defaultWindowSize);
        }
        ArrayList<double[][]> newDataset = new ArrayList<double[][]>();
        newDataset.add(newMatrix);
        return new TimeSeriesDataset(newDataset);
    }

    @Override
    public TimeSeriesDataset fitTransform(TimeSeriesDataset input) {
        this.fit(input);
        return this.transform(input);
    }

    @Override
    public double[] transform(double[] input) {
        throw new UnsupportedOperationException(MSG_SPECIALFIT);
    }

    @Override
    public void fit(double[] input) {
        throw new UnsupportedOperationException(MSG_SPECIALFIT);
    }

    @Override
    public double[] fitTransform(double[] input) {
        throw new UnsupportedOperationException(MSG_SPECIALFIT);
    }

    @Override
    public double[][] transform(double[][] input) {
        if (input.length == 0) {
            throw new IllegalArgumentException("The input matrix can not be empty");
        }
        if (!this.fittedMatrix) {
            throw new NoneFittedFilterExeception("The fit mehtod must be called before transformning");
        }
        return this.blownUpMatrix;
    }

    @Override
    public void fit(double[][] input) {
        if (input.length == 0) {
            throw new IllegalArgumentException("The input matrix can not be empty");
        }
        this.blownUpMatrix = new double[input.length * (input[0].length - this.defaultWindowSize)][this.defaultWindowSize];
        for (int instance = 0; instance < input.length; ++instance) {
            for (int entry = 0; entry < input[instance].length - this.defaultWindowSize; ++entry) {
                this.blownUpMatrix[instance + entry] = Arrays.copyOfRange(input[instance], entry, entry + this.defaultWindowSize);
            }
        }
        this.fittedMatrix = true;
    }

    @Override
    public double[][] fitTransform(double[][] input) {
        this.fit(input);
        return this.transform(input);
    }
}

