/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.tsc.quality_measures;

import ai.libs.jaicore.ml.tsc.quality_measures.IQualityMeasure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FStat
implements IQualityMeasure {
    private static final long serialVersionUID = 6991529180002046551L;

    @Override
    public double assessQuality(List<Double> distances, int[] classValues) {
        HashMap classDistances = new HashMap();
        for (int i = 0; i < distances.size(); ++i) {
            if (!classDistances.containsKey(classValues[i])) {
                classDistances.put(classValues[i], new ArrayList());
            }
            ((List)classDistances.get(classValues[i])).add(distances.get(i));
        }
        int numClasses = classDistances.size();
        HashMap<Integer, Double> classMeans = new HashMap<Integer, Double>();
        for (Map.Entry entry : classDistances.entrySet()) {
            Integer clazz = (Integer)entry.getKey();
            classMeans.put(clazz, ((List)entry.getValue()).stream().mapToDouble(a -> a).average().getAsDouble());
        }
        double completeMean = distances.stream().mapToDouble(a -> a).average().getAsDouble();
        double denominator = 0.0;
        double result = 0.0;
        for (Map.Entry entry : classMeans.entrySet()) {
            Integer clazz = (Integer)entry.getKey();
            double mean = (Double)entry.getValue();
            result += Math.pow(mean - completeMean, 2.0);
            for (Double dist : (List)classDistances.get(clazz)) {
                denominator += Math.pow(dist - mean, 2.0);
            }
        }
        result /= (double)(numClasses - 1);
        if ((denominator /= (double)(distances.size() - numClasses)) == 0.0) {
            throw new IllegalArgumentException("Given arguments yield a 0 " + denominator);
        }
        return result /= denominator;
    }
}

