/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.weka.dataset.splitter;

import ai.libs.jaicore.ml.weka.dataset.splitter.RandomMultilabelCrossValidation;
import weka.core.Instances;

public class MultilabelDatasetSplitter {
    private static final String SPLIT_TECHNIQUE_AND_DETAILS_SEPARATOR = ":";

    private MultilabelDatasetSplitter() {
    }

    public static Instances getTestSplit(Instances data, String splitDescription, String testFold, String seed) {
        if (testFold.equals("-1")) {
            return data;
        }
        String[] splitTechniqueAndDetails = splitDescription.split(MultilabelDatasetSplitter.getSplitTechniqueAndDetailsSeparator());
        switch (splitTechniqueAndDetails[0]) {
            case "2cv": {
                return new RandomMultilabelCrossValidation().getTestSplit(data, Integer.parseInt(seed), Integer.parseInt(testFold), new RandomMultilabelCrossValidation().generateSplittingInfo(0.5, 0.5));
            }
            case "PseudoRandom": {
                return new RandomMultilabelCrossValidation().getTestSplit(data, Integer.parseInt(seed), Integer.parseInt(testFold), splitTechniqueAndDetails[1]);
            }
            case "mccv": {
                return new RandomMultilabelCrossValidation().getTestSplit(data, Integer.parseInt(seed), Integer.parseInt(testFold), splitTechniqueAndDetails[1]);
            }
        }
        throw new IllegalArgumentException("Split technique " + splitTechniqueAndDetails[0] + " not supported.");
    }

    public static Instances getTrainSplit(Instances data, String splitDescription, String testFold, String seed) {
        if (testFold.equals("-1")) {
            return data;
        }
        String[] splitTechniqueAndDetails = splitDescription.split(MultilabelDatasetSplitter.getSplitTechniqueAndDetailsSeparator());
        switch (splitTechniqueAndDetails[0]) {
            case "mccv": {
                return new RandomMultilabelCrossValidation().getTrainSplit(data, Integer.parseInt(seed), Integer.parseInt(testFold), splitTechniqueAndDetails[1]);
            }
            case "2cv": {
                return new RandomMultilabelCrossValidation().getTrainSplit(data, Integer.parseInt(seed), Integer.parseInt(testFold), new RandomMultilabelCrossValidation().generateSplittingInfo(0.5, 0.5));
            }
            case "PseudoRandom": {
                return new RandomMultilabelCrossValidation().getTrainSplit(data, Integer.parseInt(seed), Integer.parseInt(testFold), splitTechniqueAndDetails[1]);
            }
        }
        throw new IllegalArgumentException("Split technique " + splitTechniqueAndDetails[0] + " not supported.");
    }

    public static String getSplitTechniqueAndDetailsSeparator() {
        return SPLIT_TECHNIQUE_AND_DETAILS_SEPARATOR;
    }
}

