/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.loss.dataset;

import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.IntStream;
import org.api4.java.ai.ml.core.evaluation.IPredictionAndGroundTruthTable;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicInstancePredictionPerformanceMeasure;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicPredictionPerformanceMeasure;

public abstract class APredictionPerformanceMeasure<E, A>
implements IDeterministicPredictionPerformanceMeasure<E, A> {
    protected void checkConsistency(List<? extends E> expected, List<? extends A> actual) {
        if (expected.size() != actual.size()) {
            throw new IllegalArgumentException("The expected and predicted classification lists must be of the same length.");
        }
    }

    public double loss(IPredictionAndGroundTruthTable<? extends E, ? extends A> pairTable) {
        return this.loss(pairTable.getGroundTruthAsList(), pairTable.getPredictionsAsList());
    }

    public double loss(List<? extends E> expected, List<? extends A> actual) {
        return 1.0 - this.score(expected, actual);
    }

    public double score(List<? extends E> expected, List<? extends A> actual) {
        return 1.0 - this.loss(expected, actual);
    }

    public double score(IPredictionAndGroundTruthTable<? extends E, ? extends A> pairTable) {
        return this.score(pairTable.getGroundTruthAsList(), pairTable.getPredictionsAsList());
    }

    protected double averageInstanceWiseLoss(List<E> expected, List<A> actual, IDeterministicInstancePredictionPerformanceMeasure<A, E> subMeasure) {
        OptionalDouble res = IntStream.range(0, expected.size()).mapToDouble(x -> subMeasure.loss(expected.get(x), actual.get(x))).average();
        if (res.isPresent()) {
            return res.getAsDouble();
        }
        throw new IllegalStateException("The submeasure could not be aggregated.");
    }

    protected double averageInstanceWiseScore(List<E> expected, List<A> actual, IDeterministicInstancePredictionPerformanceMeasure<A, E> subMeasure) {
        OptionalDouble res = IntStream.range(0, expected.size()).mapToDouble(x -> subMeasure.score(expected.get(x), actual.get(x))).average();
        if (res.isPresent()) {
            return res.getAsDouble();
        }
        throw new IllegalStateException("The submeasure could not be aggregated.");
    }
}

