/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.loss.dataset;

import ai.libs.jaicore.basic.aggregate.reals.Mean;
import ai.libs.jaicore.ml.classification.loss.dataset.EClassificationPerformanceMeasure;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.api4.java.ai.ml.core.evaluation.IPredictionAndGroundTruthTable;
import org.api4.java.ai.ml.core.evaluation.execution.IAggregatedPredictionPerformanceMeasure;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicHomogeneousPredictionPerformanceMeasure;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicPredictionPerformanceMeasure;
import org.api4.java.common.aggregate.IAggregateFunction;

public enum EAggregatedClassifierMetric implements IAggregatedPredictionPerformanceMeasure<Object, Object>
{
    MEAN_ERRORRATE(EClassificationPerformanceMeasure.ERRORRATE, (IAggregateFunction<Double>)new Mean());

    private final IDeterministicHomogeneousPredictionPerformanceMeasure<Object> lossFunction;
    private final IAggregateFunction<Double> aggregation;

    private EAggregatedClassifierMetric(IDeterministicHomogeneousPredictionPerformanceMeasure<Object> lossFunction, IAggregateFunction<Double> aggregation) {
        this.lossFunction = lossFunction;
        this.aggregation = aggregation;
    }

    public double loss(List<List<? extends Object>> expected, List<List<? extends Object>> actual) {
        int n = expected.size();
        ArrayList<Double> losses = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            losses.add(this.lossFunction.loss(expected.get(i), actual.get(i)));
        }
        return (Double)this.aggregation.aggregate(losses);
    }

    public double loss(List<IPredictionAndGroundTruthTable<? extends Object, ? extends Object>> pairTables) {
        return (Double)this.aggregation.aggregate(pairTables.stream().map(arg_0 -> this.lossFunction.loss(arg_0)).collect(Collectors.toList()));
    }

    public double score(List<List<? extends Object>> expected, List<List<? extends Object>> actual) {
        return 1.0 - this.loss(expected, actual);
    }

    public double score(List<IPredictionAndGroundTruthTable<? extends Object, ? extends Object>> pairTables) {
        return 1.0 - this.loss(pairTables);
    }

    public IDeterministicPredictionPerformanceMeasure<Object, Object> getBaseMeasure() {
        return this.lossFunction;
    }
}

