/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.loss.dataset;

import ai.libs.jaicore.ml.classification.loss.dataset.ErrorRate;
import ai.libs.jaicore.ml.classification.loss.dataset.F1Measure;
import ai.libs.jaicore.ml.classification.loss.dataset.FalseNegatives;
import ai.libs.jaicore.ml.classification.loss.dataset.FalsePositives;
import ai.libs.jaicore.ml.classification.loss.dataset.Precision;
import ai.libs.jaicore.ml.classification.loss.dataset.Recall;
import ai.libs.jaicore.ml.classification.loss.dataset.TrueNegatives;
import ai.libs.jaicore.ml.classification.loss.dataset.TruePositives;
import java.util.List;
import org.api4.java.ai.ml.core.evaluation.IPredictionAndGroundTruthTable;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicHomogeneousPredictionPerformanceMeasure;

public enum EClassificationPerformanceMeasure implements IDeterministicHomogeneousPredictionPerformanceMeasure<Object>
{
    ERRORRATE(new ErrorRate()),
    TRUE_NEGATIVES_WITH_1_POSITIVE(new TrueNegatives(1)),
    TRUE_POSITIVES_WITH_1_POSITIVE(new TruePositives(1)),
    FALSE_NEGATIVES_WITH_1_POSITIVE(new FalseNegatives(1)),
    FALSE_POSITIVES_WITH_1_POSITIVE(new FalsePositives(1)),
    PRECISION_WITH_1_POSITIVE(new Precision(1)),
    RECALL_WITH_1_POSITIVE(new Recall(1)),
    F1_WITH_1_POSITIVE(new F1Measure(1));

    private final IDeterministicHomogeneousPredictionPerformanceMeasure<Object> measure;

    private EClassificationPerformanceMeasure(IDeterministicHomogeneousPredictionPerformanceMeasure<Object> measure) {
        this.measure = measure;
    }

    public double loss(List<? extends Object> actual, List<? extends Object> expected) {
        return this.measure.loss(actual, expected);
    }

    public double loss(IPredictionAndGroundTruthTable<? extends Object, ? extends Object> pairTable) {
        return this.measure.loss(pairTable);
    }

    public double score(List<? extends Object> expected, List<? extends Object> actual) {
        return this.measure.score(expected, actual);
    }

    public double score(IPredictionAndGroundTruthTable<? extends Object, ? extends Object> pairTable) {
        return this.measure.score(pairTable);
    }
}

