/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.loss.dataset;

import ai.libs.jaicore.ml.classification.loss.dataset.AHomogeneousPredictionPerformanceMeasure;
import ai.libs.jaicore.ml.classification.loss.dataset.Precision;
import ai.libs.jaicore.ml.classification.loss.dataset.Recall;
import java.util.List;

public class FMeasure
extends AHomogeneousPredictionPerformanceMeasure<Object> {
    private final double beta;
    private final Precision precision;
    private final Recall recall;

    public FMeasure(double beta, Object positiveClass) {
        this.beta = beta;
        this.precision = new Precision(positiveClass);
        this.recall = new Recall(positiveClass);
    }

    @Override
    public double score(List<?> expected, List<?> actual) {
        if (expected.size() != actual.size()) {
            throw new IllegalArgumentException("Expected and actual must be of the same length.");
        }
        double vPrecision = this.precision.score(expected, actual);
        double vRecall = this.recall.score((List<? extends Object>)expected, (List<? extends Object>)actual);
        double denominator = Math.pow(this.beta, 2.0) * vPrecision + vRecall;
        return denominator == 0.0 ? 0.0 : (1.0 + Math.pow(this.beta, 2.0)) * (vPrecision * vRecall) / denominator;
    }
}

