/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.multilabel;

import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.api4.java.ai.ml.classification.multilabel.evaluation.IMultiLabelClassification;
import org.api4.java.ai.ml.classification.multilabel.evaluation.IMultiLabelClassificationPredictionBatch;

public class MultiLabelClassificationPredictionBatch
implements IMultiLabelClassificationPredictionBatch {
    private List<? extends IMultiLabelClassification> batch;

    public MultiLabelClassificationPredictionBatch(List<? extends IMultiLabelClassification> batch) {
        this.batch = batch;
    }

    public MultiLabelClassificationPredictionBatch(IMultiLabelClassification[] batch) {
        this(Arrays.asList(batch));
    }

    public IMultiLabelClassification get(int index) {
        return this.batch.get(index);
    }

    public int getNumPredictions() {
        return this.batch.size();
    }

    public List<? extends IMultiLabelClassification> getPredictions() {
        return this.batch;
    }

    public double[][] getPredictionMatrix() {
        double[][] predictionMatrix = new double[this.batch.size()][];
        IntStream.range(0, this.batch.size()).forEach(x -> {
            predictionMatrix[x] = this.batch.get(x).getPrediction();
        });
        return predictionMatrix;
    }

    public int[][] getThresholdedPredictionMatrix(double threshold) {
        int[][] predictionMatrix = new int[this.batch.size()][];
        IntStream.range(0, this.batch.size()).forEach(x -> {
            predictionMatrix[x] = this.batch.get(x).getPrediction(threshold);
        });
        return predictionMatrix;
    }

    public int[][] getThresholdedPredictionMatrix(double[] threshold) {
        int[][] predictionMatrix = new int[this.batch.size()][];
        IntStream.range(0, this.batch.size()).forEach(x -> {
            predictionMatrix[x] = this.batch.get(x).getPrediction(threshold);
        });
        return predictionMatrix;
    }
}

