/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.multilabel.evaluation.loss;

import ai.libs.jaicore.ml.classification.multilabel.evaluation.loss.AThresholdBasedMultiLabelClassificationMeasure;
import ai.libs.jaicore.ml.classification.multilabel.evaluation.loss.ExactMatch;
import ai.libs.jaicore.ml.classification.multilabel.evaluation.loss.F1MacroAverageL;
import ai.libs.jaicore.ml.classification.multilabel.evaluation.loss.Hamming;
import ai.libs.jaicore.ml.classification.multilabel.evaluation.loss.RankLoss;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import org.api4.java.ai.ml.classification.multilabel.evaluation.IMultiLabelClassification;
import org.api4.java.ai.ml.classification.multilabel.evaluation.loss.IMultiLabelClassificationPredictionPerformanceMeasure;

public class AutoMEKAGGPFitnessMeasureLoss
extends AThresholdBasedMultiLabelClassificationMeasure {
    private IMultiLabelClassificationPredictionPerformanceMeasure[] measures;

    public AutoMEKAGGPFitnessMeasureLoss() {
        this.measures = new IMultiLabelClassificationPredictionPerformanceMeasure[]{new ExactMatch(), new F1MacroAverageL(), new Hamming(), new RankLoss()};
    }

    public AutoMEKAGGPFitnessMeasureLoss(double threshold) {
        super(threshold);
        this.measures = new IMultiLabelClassificationPredictionPerformanceMeasure[]{new ExactMatch(threshold), new F1MacroAverageL(threshold), new Hamming(threshold), new RankLoss(threshold)};
    }

    @Override
    public double loss(List<? extends int[]> expected, List<? extends IMultiLabelClassification> actual) {
        OptionalDouble res = Arrays.stream(this.measures).mapToDouble(x -> x.loss(expected, actual)).average();
        if (res.isPresent()) {
            return res.getAsDouble();
        }
        throw new IllegalStateException("Could not take the average of all base measures");
    }
}

