/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.multilabel.evaluation.loss;

import ai.libs.jaicore.ml.classification.loss.dataset.F1Measure;
import ai.libs.jaicore.ml.classification.multilabel.evaluation.loss.AThresholdBasedMultiLabelClassificationMeasure;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalDouble;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.api4.java.ai.ml.classification.multilabel.evaluation.IMultiLabelClassification;

public class InstanceWiseF1
extends AThresholdBasedMultiLabelClassificationMeasure {
    public InstanceWiseF1(double threshold) {
        super(threshold);
    }

    public InstanceWiseF1() {
    }

    @Override
    public double loss(List<? extends int[]> expected, List<? extends IMultiLabelClassification> actual) {
        return 1.0 - this.score(expected, actual);
    }

    @Override
    public double score(List<? extends int[]> expected, List<? extends IMultiLabelClassification> actual) {
        this.checkConsistency(expected, actual);
        int[][] expectedMatrix = this.listToMatrix(expected);
        int[][] actualMatrix = this.listToThresholdedRelevanceMatrix(actual);
        F1Measure baseMeasure = new F1Measure(1);
        OptionalDouble res = IntStream.range(0, expectedMatrix.length).mapToDouble(x -> baseMeasure.score((List<?>)Arrays.stream(expectedMatrix[x]).mapToObj(Integer::valueOf).collect(Collectors.toList()), (List<?>)Arrays.stream(actualMatrix[x]).mapToObj(Integer::valueOf).collect(Collectors.toList()))).average();
        if (!res.isPresent()) {
            throw new IllegalStateException("Could not determine average instance-wise f measure.");
        }
        return res.getAsDouble();
    }
}

