/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.singlelabel;

import ai.libs.jaicore.ml.core.evaluation.Prediction;
import java.util.Map;
import org.api4.java.ai.ml.classification.singlelabel.evaluation.ISingleLabelClassification;

public class SingleLabelClassification
extends Prediction
implements ISingleLabelClassification {
    private Map<Integer, Double> labelProbabilities;

    public SingleLabelClassification(int predicted) {
        super(predicted);
    }

    public SingleLabelClassification(Map<Integer, Double> labelProbabilities) {
        super(SingleLabelClassification.labelWithHighestProbability(labelProbabilities));
        this.labelProbabilities = labelProbabilities;
    }

    private static int labelWithHighestProbability(Map<Integer, Double> labelProbabilities) {
        Map.Entry<Integer, Double> highestProbEntry = null;
        for (Map.Entry<Integer, Double> entry : labelProbabilities.entrySet()) {
            if (highestProbEntry != null && !((Double)highestProbEntry.getValue() < entry.getValue())) continue;
            highestProbEntry = entry;
        }
        if (highestProbEntry == null) {
            throw new IllegalArgumentException("No prediction contained");
        }
        return (Integer)highestProbEntry.getKey();
    }

    public int getIntPrediction() {
        return (Integer)super.getPrediction();
    }

    @Override
    public Integer getPrediction() {
        return this.getIntPrediction();
    }

    @Override
    public Integer getLabelWithHighestProbability() {
        return this.getIntPrediction();
    }

    public Map<Integer, Double> getClassDistribution() {
        return this.labelProbabilities;
    }

    public double getProbabilityOfLabel(int label) {
        return this.labelProbabilities.containsKey(label) ? this.labelProbabilities.get(label) : 0.0;
    }

    public Map<Integer, Double> getClassConfidence() {
        throw new UnsupportedOperationException("Not yet implemented.");
    }
}

