/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.singlelabel.timeseries.filter;

import ai.libs.jaicore.ml.classification.singlelabel.timeseries.dataset.TimeSeriesDataset2;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.exception.NoneFittedFilterExeception;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.filter.AFilter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math3.complex.Complex;

public class DFT
extends AFilter {
    private static final String MSG_EMPTYINPUT = "The input can not be empty";
    private List<double[][]> dftCoefficients = new ArrayList<double[][]>();
    private double[][] dftCoefficientsMatrix;
    private double[] dftCoefficientsInstance;
    private int numberOfDisieredCoefficients = 10;
    private boolean fittedInstance = false;
    private boolean fittedMatrix = false;
    private boolean fitted = false;
    private boolean meanCorrected = false;
    private int startingpoint = 0;
    private boolean rekursivFirstInstance;

    public void setNumberOfDisieredCoefficients(int numberOfDisieredCoefficients) {
        this.numberOfDisieredCoefficients = numberOfDisieredCoefficients;
    }

    public void setMeanCorrected(boolean meanCorrected) {
        this.meanCorrected = meanCorrected;
        if (this.meanCorrected) {
            this.startingpoint = 1;
            if (this.numberOfDisieredCoefficients == 1) {
                throw new IllegalArgumentException("The number of desiered dft coefficients would be zero.");
            }
        } else {
            this.startingpoint = 0;
        }
    }

    @Override
    public TimeSeriesDataset2 transform(TimeSeriesDataset2 input) {
        if (input.isEmpty()) {
            throw new IllegalArgumentException("This method can not work with an empty dataset.");
        }
        if (!this.fitted) {
            throw new NoneFittedFilterExeception("The fit method must be called before the transform method is called.");
        }
        return new TimeSeriesDataset2(this.dftCoefficients, null, null);
    }

    @Override
    public void fit(TimeSeriesDataset2 input) {
        if (input.isEmpty()) {
            throw new IllegalArgumentException("This method can not work with an empty dataset.");
        }
        this.dftCoefficients.clear();
        for (int matrix = 0; matrix < input.getNumberOfVariables(); ++matrix) {
            this.fitTransform(input.getValues(matrix));
            this.fittedMatrix = false;
            this.dftCoefficients.add(this.dftCoefficientsMatrix);
        }
        this.fitted = true;
    }

    @Override
    public double[] transform(double[] input) {
        if (!this.fittedInstance) {
            throw new NoneFittedFilterExeception("The fit method must be called before the transform method.");
        }
        if (input.length == 0) {
            throw new IllegalArgumentException("The input can not be empty.");
        }
        return this.dftCoefficientsInstance;
    }

    @Override
    public void fit(double[] input) {
        if (this.numberOfDisieredCoefficients > input.length) {
            throw new IllegalArgumentException("There cannot be more DFT coefficents calcualated than there entrys in the basis instance.");
        }
        if (input.length == 0) {
            throw new IllegalArgumentException("The to transform instance can not be of length zero.");
        }
        if (this.rekursivFirstInstance) {
            this.startingpoint = 0;
        }
        this.dftCoefficientsInstance = new double[this.numberOfDisieredCoefficients * 2 - this.startingpoint * 2];
        int loopcounter = 0;
        for (int coefficient = this.startingpoint; coefficient < this.numberOfDisieredCoefficients; ++coefficient) {
            Complex result = new Complex(0.0, 0.0);
            for (int entry = 0; entry < input.length; ++entry) {
                double realpart = Math.cos(-(1.0 / (double)input.length) * 2.0 * Math.PI * (double)entry * (double)coefficient);
                double imaginarypart = Math.sin(-(1.0 / (double)input.length) * 2.0 * Math.PI * (double)entry * (double)coefficient);
                Complex tmp = new Complex(realpart, imaginarypart);
                tmp = tmp.multiply(input[entry]);
                result = result.add(tmp);
            }
            this.dftCoefficientsInstance[loopcounter] = result.getReal();
            this.dftCoefficientsInstance[loopcounter + 1] = result.getImaginary();
            loopcounter += 2;
        }
        if (this.rekursivFirstInstance && this.meanCorrected) {
            this.startingpoint = 1;
        }
        this.fittedInstance = true;
    }

    @Override
    public double[] fitTransform(double[] input) {
        this.fit(input);
        return this.transform(input);
    }

    @Override
    public double[][] transform(double[][] input) {
        if (!this.fittedMatrix) {
            throw new NoneFittedFilterExeception("The fit method must be called before transforming");
        }
        if (input.length == 0) {
            throw new IllegalArgumentException(MSG_EMPTYINPUT);
        }
        return this.dftCoefficientsMatrix;
    }

    @Override
    public void fit(double[][] input) {
        this.dftCoefficientsMatrix = new double[input.length][this.numberOfDisieredCoefficients * 2 - this.startingpoint * 2];
        double[] dftCoefficientsOFInstance = null;
        for (int instance = 0; instance < input.length; ++instance) {
            dftCoefficientsOFInstance = this.fitTransform(input[instance]);
            this.fittedInstance = false;
            this.dftCoefficientsMatrix[instance] = dftCoefficientsOFInstance;
        }
        this.fittedMatrix = true;
    }

    @Override
    public double[][] fitTransform(double[][] input) {
        this.fit(input);
        return this.transform(input);
    }

    public double[][] rekursivDFT(double[][] input) {
        if (input.length == 0) {
            throw new IllegalArgumentException(MSG_EMPTYINPUT);
        }
        if (input[0].length < this.numberOfDisieredCoefficients) {
            throw new IllegalArgumentException("Can not compute more dft coefficents than the length of the input.");
        }
        if (this.numberOfDisieredCoefficients < 0) {
            throw new IllegalArgumentException("The number of desiered DFT coefficients can not be negativ.");
        }
        Complex[][] outputComplex = new Complex[input.length][this.numberOfDisieredCoefficients];
        for (int i = 0; i < input.length; ++i) {
            if (i == 0) {
                this.rekursivFirstInstance = true;
                double[] tmp = this.fitTransform(input[i]);
                this.rekursivFirstInstance = false;
                Complex[] firstEntry = new Complex[this.numberOfDisieredCoefficients];
                for (int entry = 0; entry < tmp.length - 1; entry += 2) {
                    firstEntry[entry / 2] = new Complex(tmp[entry], tmp[entry + 1]);
                }
                outputComplex[0] = firstEntry;
                continue;
            }
            Complex[] coefficientsForInstance = new Complex[this.numberOfDisieredCoefficients];
            for (int j = 0; j < this.numberOfDisieredCoefficients; ++j) {
                coefficientsForInstance[j] = this.vFormular(j, input[i].length).multiply(outputComplex[i - 1][j].subtract(new Complex(input[i - 1][0], 0.0).subtract(new Complex(input[i][input[i].length - 1], 0.0))));
            }
            outputComplex[i] = coefficientsForInstance;
        }
        return this.conversion(outputComplex);
    }

    private double[][] conversion(Complex[][] input) {
        if (input.length == 0) {
            throw new IllegalArgumentException(MSG_EMPTYINPUT);
        }
        double[][] output = new double[input.length][input[0].length * 2 - this.startingpoint * 2];
        for (int i = 0; i < input.length; ++i) {
            int loopcounter = this.startingpoint;
            for (int j = 0; j < output[i].length; j += 2) {
                output[i][j] = input[i][loopcounter].getReal();
                output[i][j + 1] = input[i][loopcounter].getImaginary();
                ++loopcounter;
            }
        }
        return output;
    }

    private Complex vFormular(int coefficient, int legthOfinstance) {
        return new Complex(Math.cos(Math.PI * 2 * (double)coefficient / (double)legthOfinstance), Math.sin(Math.PI * 2 * (double)coefficient / (double)legthOfinstance));
    }

    public TimeSeriesDataset2 rekursivDFT(TimeSeriesDataset2 input) {
        ArrayList<double[][]> tmp = new ArrayList<double[][]>();
        for (int matrix = 0; matrix < input.getNumberOfVariables(); ++matrix) {
            tmp.add(this.rekursivDFT(input.getValues(matrix)));
        }
        return new TimeSeriesDataset2(tmp, null, null);
    }
}

