/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.singlelabel.timeseries.filter;

import ai.libs.jaicore.ml.classification.singlelabel.timeseries.dataset.TimeSeriesDataset2;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.exception.NoneFittedFilterExeception;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.filter.DFT;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.filter.IFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class SFA
implements IFilter {
    private static final String MSG_NOEMPTYDS = "This method can not work with an empty dataset.";
    private static final String MSG_NOSINGLEINSTANCE = "To build a SFA word the full dataset has to be considerd therefore it is not reasonable in this context to perform this operation on a single Instance.";
    private double[] alphabet;
    private boolean meanCorrected;
    private boolean fitted = false;
    private boolean fittedMatrix = false;
    private TimeSeriesDataset2 dFTDataset = null;
    private double[][] dftMatrix = null;
    private int numberOfDesieredDFTCoefficients;
    private List<double[][]> lookupTable = new ArrayList<double[][]>();
    private double[][] lookUpTableMatrix = null;
    private boolean rekursiv;

    public void setNumberOfDesieredDFTCoefficients(int numberOfDesieredDFTCoefficients) {
        this.numberOfDesieredDFTCoefficients = numberOfDesieredDFTCoefficients;
    }

    public void disableRekursiv() {
        this.rekursiv = false;
    }

    public void enableRekursiv() {
        this.rekursiv = true;
    }

    public SFA(double[] alphabet, int wordLength) {
        this.alphabet = alphabet;
        this.numberOfDesieredDFTCoefficients = wordLength / 2;
    }

    @Override
    public TimeSeriesDataset2 transform(TimeSeriesDataset2 input) {
        if (input.isEmpty()) {
            throw new IllegalArgumentException(MSG_NOEMPTYDS);
        }
        if (!this.fitted) {
            throw new NoneFittedFilterExeception("The filter must be fitted before it can transform.");
        }
        ArrayList<double[][]> sfaDataset = new ArrayList<double[][]>();
        for (int matrix = 0; matrix < this.dFTDataset.getNumberOfVariables(); ++matrix) {
            double[][] sfaWords = new double[this.dFTDataset.getNumberOfInstances()][this.numberOfDesieredDFTCoefficients * 2];
            for (int instance = 0; instance < this.dFTDataset.getNumberOfInstances(); ++instance) {
                block2: for (int entry = 0; entry < this.numberOfDesieredDFTCoefficients * 2; ++entry) {
                    double[] lookup;
                    double elem = this.dFTDataset.getValues(matrix)[instance][entry];
                    if (elem < (lookup = this.lookupTable.get(matrix)[entry])[0]) {
                        sfaWords[instance][entry] = this.alphabet[0];
                        continue;
                    }
                    if (elem == lookup[0]) {
                        sfaWords[instance][entry] = this.alphabet[1];
                        continue;
                    }
                    if (elem > lookup[this.alphabet.length - 2]) {
                        sfaWords[instance][entry] = this.alphabet[this.alphabet.length - 1];
                        continue;
                    }
                    if (elem == lookup[this.alphabet.length - 2]) {
                        sfaWords[instance][entry] = this.alphabet[this.alphabet.length - 1];
                        continue;
                    }
                    for (int i = 1; i < lookup.length; ++i) {
                        if (elem < lookup[i]) {
                            sfaWords[instance][entry] = this.alphabet[i];
                            continue block2;
                        }
                        if (elem != lookup[i]) continue;
                        sfaWords[instance][entry] = this.alphabet[i + 1];
                        continue block2;
                    }
                }
            }
            sfaDataset.add(sfaWords);
        }
        return new TimeSeriesDataset2(sfaDataset, null, null);
    }

    @Override
    public void fit(TimeSeriesDataset2 input) {
        if (input.isEmpty()) {
            throw new IllegalArgumentException(MSG_NOEMPTYDS);
        }
        if (this.alphabet.length == 0) {
            throw new IllegalArgumentException("The alphabet size can not be zero.");
        }
        this.lookupTable.clear();
        DFT dftFilter = new DFT();
        dftFilter.setMeanCorrected(this.meanCorrected);
        dftFilter.setNumberOfDisieredCoefficients(this.numberOfDesieredDFTCoefficients);
        this.dFTDataset = !this.rekursiv ? dftFilter.fitTransform(input) : dftFilter.rekursivDFT(input);
        for (int matrix = 0; matrix < this.dFTDataset.getNumberOfVariables(); ++matrix) {
            double[][] lookUpTable = new double[this.numberOfDesieredDFTCoefficients * 2][this.alphabet.length - 1];
            for (int coeficient = 0; coeficient < this.numberOfDesieredDFTCoefficients * 2; ++coeficient) {
                double[] toBin = new double[input.getNumberOfInstances()];
                for (int instances = 0; instances < this.dFTDataset.getNumberOfInstances(); ++instances) {
                    toBin[instances] = this.dFTDataset.getValues(matrix)[instances][coeficient];
                }
                Arrays.sort(toBin);
                if (toBin.length == this.alphabet.length - 1) {
                    lookUpTable[coeficient] = Arrays.copyOf(toBin, this.alphabet.length - 1);
                    continue;
                }
                int splitValue = (int)Math.round((double)toBin.length / (double)this.alphabet.length);
                for (int alphabetLetter = 1; alphabetLetter < this.alphabet.length; ++alphabetLetter) {
                    lookUpTable[coeficient][alphabetLetter - 1] = toBin[alphabetLetter * splitValue];
                }
            }
            this.lookupTable.add(lookUpTable);
        }
        this.fitted = true;
    }

    @Override
    public TimeSeriesDataset2 fitTransform(TimeSeriesDataset2 input) {
        this.fit(input);
        return this.transform(input);
    }

    @Override
    public double[] transform(double[] input) {
        throw new UnsupportedOperationException(MSG_NOSINGLEINSTANCE);
    }

    @Override
    public void fit(double[] input) {
        throw new UnsupportedOperationException(MSG_NOSINGLEINSTANCE);
    }

    @Override
    public double[] fitTransform(double[] input) {
        throw new UnsupportedOperationException(MSG_NOSINGLEINSTANCE);
    }

    @Override
    public double[][] transform(double[][] input) {
        if (input.length == 0) {
            throw new IllegalArgumentException(MSG_NOEMPTYDS);
        }
        if (!this.fittedMatrix) {
            throw new NoneFittedFilterExeception("The filter must be fitted before it can transform.");
        }
        double[][] sfaMatrix = new double[this.dftMatrix.length][this.numberOfDesieredDFTCoefficients * 2];
        for (int instance = 0; instance < this.dftMatrix.length; ++instance) {
            for (int entry = 0; entry < this.numberOfDesieredDFTCoefficients * 2; ++entry) {
                double elem = this.dftMatrix[instance][entry];
                double[] lookup = this.lookUpTableMatrix[entry];
                if (elem < lookup[0]) {
                    sfaMatrix[instance][entry] = this.alphabet[0];
                }
                if (elem == lookup[0]) {
                    sfaMatrix[instance][entry] = this.alphabet[1];
                }
                if (elem > lookup[this.alphabet.length - 2]) {
                    sfaMatrix[instance][entry] = this.alphabet[this.alphabet.length - 1];
                }
                if (elem == lookup[this.alphabet.length - 2]) {
                    sfaMatrix[instance][entry] = this.alphabet[this.alphabet.length - 1];
                    continue;
                }
                for (int i = 1; i < lookup.length - 2; ++i) {
                    if (elem > lookup[i]) {
                        sfaMatrix[instance][entry] = this.alphabet[i];
                    }
                    if (elem != lookup[i]) continue;
                    sfaMatrix[instance][entry] = this.alphabet[i + 1];
                }
            }
        }
        return sfaMatrix;
    }

    @Override
    public void fit(double[][] input) {
        if (input.length == 0) {
            throw new IllegalArgumentException(MSG_NOEMPTYDS);
        }
        if (this.alphabet.length == 0) {
            throw new IllegalArgumentException("The alphabet size can not be zero.");
        }
        DFT dftFilterMatrix = new DFT();
        dftFilterMatrix.setNumberOfDisieredCoefficients(this.numberOfDesieredDFTCoefficients);
        this.dftMatrix = !this.rekursiv ? dftFilterMatrix.fitTransform(input) : dftFilterMatrix.rekursivDFT(input);
        this.lookUpTableMatrix = new double[this.numberOfDesieredDFTCoefficients * 2][this.alphabet.length - 1];
        for (int coeficient = 0; coeficient < this.numberOfDesieredDFTCoefficients * 2; ++coeficient) {
            double[] toBin = new double[input.length];
            for (int instances = 0; instances < input.length; ++instances) {
                toBin[instances] = this.dftMatrix[instances][coeficient];
            }
            Arrays.sort(toBin);
            if (toBin.length == this.alphabet.length - 1) {
                this.lookUpTableMatrix[coeficient] = Arrays.copyOf(toBin, this.alphabet.length - 1);
                continue;
            }
            int splitValue = (int)Math.round((double)toBin.length / (double)this.alphabet.length);
            for (int alphabetLetter = 0; alphabetLetter < this.alphabet.length - 1; ++alphabetLetter) {
                this.lookUpTableMatrix[coeficient][alphabetLetter] = toBin[alphabetLetter + splitValue];
            }
        }
        this.fittedMatrix = true;
    }

    @Override
    public double[][] fitTransform(double[][] input) {
        this.fit(input);
        return this.transform(input);
    }
}

