/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.singlelabel.timeseries.learner;

import ai.libs.jaicore.basic.IOwnerBasedAlgorithmConfig;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.dataset.TimeSeriesDataset2;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.filter.SFA;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.filter.SlidingWindowBuilder;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.filter.ZTransformer;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.learner.ASimplifiedTSCLearningAlgorithm;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.learner.BOSSClassifier;
import ai.libs.jaicore.ml.classification.singlelabel.timeseries.util.HistogramBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aeonbits.owner.Config;
import org.api4.java.algorithm.events.IAlgorithmEvent;

public class BOSSLearningAlgorithm
extends ASimplifiedTSCLearningAlgorithm<Integer, BOSSClassifier> {
    private List<ArrayList<HashMap<Integer, Integer>>> multivirateHistograms = new ArrayList<ArrayList<HashMap<Integer, Integer>>>();
    private ArrayList<HashMap<Integer, Integer>> histograms = new ArrayList();

    public BOSSLearningAlgorithm(IBossAlgorithmConfig config, BOSSClassifier classifier, TimeSeriesDataset2 data) {
        super(config, classifier, data);
    }

    @Override
    public IAlgorithmEvent nextWithException() {
        return null;
    }

    public BOSSClassifier call() {
        this.multivirateHistograms.clear();
        IBossAlgorithmConfig config = (IBossAlgorithmConfig)this.getConfig();
        HistogramBuilder histoBuilder = new HistogramBuilder();
        SFA sfa = new SFA(config.alphabet(), config.wordLength());
        SlidingWindowBuilder slide = new SlidingWindowBuilder();
        slide.setDefaultWindowSize(config.windowSize());
        TimeSeriesDataset2 data = (TimeSeriesDataset2)this.getInput();
        for (int matrix = 0; matrix < data.getNumberOfVariables(); ++matrix) {
            this.histograms.clear();
            for (int instance = 0; instance < data.getNumberOfInstances(); ++instance) {
                TimeSeriesDataset2 tmp = slide.specialFitTransform(data.getValues(matrix)[instance]);
                ZTransformer znorm = new ZTransformer();
                for (int i = 0; i < tmp.getValues(0).length; ++i) {
                    tmp.getValues((int)0)[i] = znorm.fitTransform(tmp.getValues(0)[i]);
                }
                TimeSeriesDataset2 tmpTransformed = sfa.fitTransform(tmp);
                Map<Integer, Integer> histogram = histoBuilder.histogramForInstance(tmpTransformed);
                this.histograms.add(new HashMap<Integer, Integer>(histogram));
            }
            this.multivirateHistograms.add(this.histograms);
        }
        BOSSClassifier model = (BOSSClassifier)this.getClassifier();
        model.setTrainingData((TimeSeriesDataset2)this.getInput());
        return model;
    }

    public static interface IBossAlgorithmConfig
    extends IOwnerBasedAlgorithmConfig {
        public static final String K_WINDOW_SIZE = "boss.windowsize";
        public static final String K_ALPHABET_SIZE = "boss.alphabetsize";
        public static final String K_ALPHABET = "boss.alphabet";
        public static final String K_WORDLENGTH = "boss.wordlength";
        public static final String K_MEANCORRECTED = "boss.meancorrected";

        @Config.Key(value="boss.windowsize")
        public int windowSize();

        @Config.Key(value="boss.alphabetsize")
        @Config.DefaultValue(value="4")
        public int alphabetSize();

        @Config.Key(value="boss.alphabet")
        public double[] alphabet();

        @Config.Key(value="boss.wordlength")
        public int wordLength();

        @Config.Key(value="boss.meancorrected")
        public boolean meanCorrected();
    }
}

