/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.classification.singlelabel.timeseries.shapelets;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Shapelet {
    private double[] data;
    private int startIndex;
    private int length;
    private int instanceIndex;
    private double determinedQuality;

    public Shapelet(double[] data, int startIndex, int length, int instanceIndex, double determinedQuality) {
        this.data = data;
        this.startIndex = startIndex;
        this.length = length;
        this.instanceIndex = instanceIndex;
        this.determinedQuality = determinedQuality;
    }

    public Shapelet(double[] data, int startIndex, int length, int instanceIndex) {
        this.data = data;
        this.startIndex = startIndex;
        this.length = length;
        this.instanceIndex = instanceIndex;
    }

    public double[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.length;
    }

    public int getStartIndex() {
        return this.startIndex;
    }

    public int getInstanceIndex() {
        return this.instanceIndex;
    }

    public double getDeterminedQuality() {
        return this.determinedQuality;
    }

    public void setDeterminedQuality(double determinedQuality) {
        this.determinedQuality = determinedQuality;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.data);
        long temp = Double.doubleToLongBits(this.determinedQuality);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        result = 31 * result + this.instanceIndex;
        result = 31 * result + this.length;
        result = 31 * result + this.startIndex;
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Shapelet) {
            Shapelet other = (Shapelet)obj;
            if (this.data == null && other.getData() != null || this.data != null && other.getData() == null) {
                return false;
            }
            return (this.data == null && other.getData() == null || Arrays.equals(this.data, other.getData())) && this.length == other.getLength() && this.determinedQuality == other.determinedQuality && this.instanceIndex == other.instanceIndex;
        }
        return super.equals(obj);
    }

    public String toString() {
        return "Shapelet [data=" + Arrays.toString(this.data) + ", startIndex=" + this.startIndex + ", length=" + this.length + ", instanceIndex=" + this.instanceIndex + ", determinedQuality=" + this.determinedQuality + "]";
    }

    public static void sortByLengthAsc(List<Shapelet> shapelets) {
        shapelets.sort((s1, s2) -> Integer.compare(s1.getLength(), s2.getLength()));
    }

    public static Shapelet getHighestQualityShapeletInList(List<Shapelet> shapelets) {
        return Collections.max(shapelets, (s1, s2) -> -1 * Double.compare(s1.getDeterminedQuality(), s2.getDeterminedQuality()));
    }
}

