/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset;

import ai.libs.jaicore.basic.reconstruction.ReconstructionInstruction;
import ai.libs.jaicore.basic.reconstruction.ReconstructionPlan;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.IntStream;
import org.api4.java.ai.ml.core.dataset.schema.ILabeledInstanceSchema;
import org.api4.java.ai.ml.core.dataset.schema.attribute.IAttribute;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.ai.ml.core.exception.DatasetCreationException;
import org.api4.java.common.reconstruction.IReconstructible;
import org.api4.java.common.reconstruction.IReconstructionInstruction;
import org.api4.java.common.reconstruction.IReconstructionPlan;

public class Dataset
extends ArrayList<ILabeledInstance>
implements ILabeledDataset<ILabeledInstance>,
IReconstructible {
    private static final long serialVersionUID = -3643080541896274181L;
    private final List<ReconstructionInstruction> instructions = new ArrayList<ReconstructionInstruction>();
    private final transient ILabeledInstanceSchema schema;

    public Dataset(ILabeledInstanceSchema schema) {
        this.schema = schema;
    }

    public Dataset(ILabeledInstanceSchema schema, List<ILabeledInstance> instances) {
        this(schema);
        this.addAll(instances);
    }

    public ILabeledInstanceSchema getInstanceSchema() {
        return this.schema;
    }

    public Dataset createEmptyCopy() throws DatasetCreationException, InterruptedException {
        return new Dataset(this.schema);
    }

    public Object[][] getFeatureMatrix() {
        return (Object[][])IntStream.range(0, this.size()).mapToObj(x -> ((ILabeledInstance)this.get(x)).getAttributes()).toArray();
    }

    public Object[] getLabelVector() {
        return IntStream.range(0, this.size()).mapToObj(x -> ((ILabeledInstance)this.get(x)).getLabel()).toArray();
    }

    public void removeColumn(int columnPos) {
        this.schema.removeAttribute(columnPos);
        this.stream().forEach((? super T x) -> x.removeColumn(columnPos));
    }

    public void removeColumn(String columnName) {
        Optional<IAttribute> att = this.schema.getAttributeList().stream().filter(x -> x.getName().equals(columnName)).findFirst();
        if (!att.isPresent()) {
            throw new IllegalArgumentException("There is no such attribute with name " + columnName + " to remove.");
        }
        this.removeColumn(this.schema.getAttributeList().indexOf(att.get()));
    }

    public void removeColumn(IAttribute attribute) {
        int index = this.schema.getAttributeList().indexOf(attribute);
        if (index < 0) {
            throw new IllegalArgumentException("There is no such attribute with name " + attribute.getName() + " to remove.");
        }
        this.removeColumn(index);
    }

    public Dataset createCopy() throws DatasetCreationException, InterruptedException {
        Dataset ds = this.createEmptyCopy();
        for (ILabeledInstance i : this) {
            ds.add(i);
        }
        return ds;
    }

    public IReconstructionPlan getConstructionPlan() {
        return new ReconstructionPlan(this.instructions);
    }

    public String getInstancesAsString() {
        StringBuilder sb = new StringBuilder();
        this.stream().map(Object::toString).forEach((? super T x) -> sb.append(x + "\n"));
        return sb.toString();
    }

    public void addInstruction(IReconstructionInstruction instruction) {
        this.instructions.add((ReconstructionInstruction)instruction);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.schema == null ? 0 : this.schema.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Dataset other = (Dataset)obj;
        return !(this.schema == null ? other.schema != null : !this.schema.equals(other.schema));
    }
}

