/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.api4.java.ai.ml.core.dataset.IDataset;
import org.api4.java.ai.ml.core.dataset.IInstance;
import org.api4.java.ai.ml.core.exception.DatasetCreationException;

public class DatasetDeriver<D extends IDataset<?>> {
    private final GenericCapsula<?> caps;

    public DatasetDeriver(D dataset) {
        this(dataset, ((IInstance)dataset.get(0)).getClass());
    }

    protected <I extends IInstance> DatasetDeriver(D dataset, Class<I> instanceClass) {
        this.caps = new GenericCapsula<I>(dataset, instanceClass);
    }

    public void add(int item, int count) {
        this.caps.addInstance(item, count);
    }

    public void add(int item) {
        this.add(item, 1);
    }

    public void addIndices(Collection<Integer> indices, int count) {
        Objects.requireNonNull(indices);
        for (int i : indices) {
            this.caps.addInstance(i, count);
        }
    }

    public void addIndices(Collection<Integer> indices) {
        this.addIndices(indices, 1);
    }

    public boolean contains(IInstance inst) {
        return ((GenericCapsula)this.caps).indicesToCopy.contains(((GenericCapsula)this.caps).dsOriginal.indexOf((Object)inst));
    }

    public D build() throws InterruptedException, DatasetCreationException {
        return (D)this.caps.getCopyBasedOnDefinedLines();
    }

    public int currentSizeOfTarget() {
        return ((GenericCapsula)this.caps).indicesToCopy.size();
    }

    public D getDataset() {
        return (D)((GenericCapsula)this.caps).dsOriginal;
    }

    public List<Integer> getIndicesOfNewInstancesInOriginalDataset() {
        return Collections.unmodifiableList(((GenericCapsula)this.caps).indicesToCopy);
    }

    public Collection<Integer> getIndicesOfNewInstancesInOriginalDataset(Collection<Integer> indicesInBuiltDataset) {
        return Collections.unmodifiableList(indicesInBuiltDataset.stream().map(((GenericCapsula)this.caps).indicesToCopy::get).collect(Collectors.toList()));
    }

    public List<Integer> getIndicesOfNewInstancesInOriginalDataset(List<Integer> indicesInBuiltDataset) {
        return Collections.unmodifiableList(indicesInBuiltDataset.stream().map(((GenericCapsula)this.caps).indicesToCopy::get).collect(Collectors.toList()));
    }

    private class GenericCapsula<I extends IInstance> {
        private final IDataset<I> dsOriginal;
        private final int initialDatasetHashCode;
        private final List<Integer> indicesToCopy = new ArrayList<Integer>();

        public GenericCapsula(IDataset<I> dataset, Class<I> clazz) {
            this.dsOriginal = dataset;
            this.initialDatasetHashCode = dataset.hashCode();
            if (!clazz.isInstance(dataset.get(0))) {
                throw new IllegalArgumentException();
            }
        }

        public IDataset<I> getCopyBasedOnDefinedLines() throws InterruptedException, DatasetCreationException {
            if (this.initialDatasetHashCode != this.dsOriginal.hashCode()) {
                throw new IllegalStateException("Dataset underlying the deriver has changed!");
            }
            IDataset copy = this.dsOriginal.createEmptyCopy();
            for (int index : this.indicesToCopy) {
                copy.add((Object)((IInstance)this.dsOriginal.get(index)));
            }
            if (copy.size() != this.indicesToCopy.size()) {
                throw new IllegalStateException("The copy has " + copy.size() + " elements while it should have " + this.indicesToCopy.size() + ".");
            }
            return copy;
        }

        public void addInstance(int inst, int count) {
            for (int i = 0; i < count; ++i) {
                this.indicesToCopy.add(inst);
            }
        }
    }
}

