/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.schema;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.api4.java.ai.ml.core.dataset.schema.IInstanceSchema;
import org.api4.java.ai.ml.core.dataset.schema.attribute.IAttribute;

public class InstanceSchema
implements IInstanceSchema {
    private String relationName;
    private final List<IAttribute> attributeList;

    public InstanceSchema(String relationName, Collection<IAttribute> attributeList) {
        this.relationName = relationName;
        this.attributeList = new ArrayList<IAttribute>(attributeList);
    }

    public List<IAttribute> getAttributeList() {
        return this.attributeList;
    }

    public IAttribute getAttribute(int pos) {
        return this.attributeList.get(pos);
    }

    public int getNumAttributes() {
        return this.attributeList.size();
    }

    public String getRelationName() {
        return this.relationName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Relation: " + this.relationName);
        sb.append("\n");
        sb.append("Features: " + this.attributeList);
        return sb.toString();
    }

    public void removeAttribute(int columnPos) {
        this.attributeList.remove(columnPos);
    }

    public void addAttribute(int pos, IAttribute attribute) {
        this.attributeList.add(pos, attribute);
    }

    public void addAttribute(IAttribute attribute) {
        this.attributeList.add(attribute);
    }

    public IInstanceSchema getCopy() {
        return new InstanceSchema(this.relationName, new ArrayList<IAttribute>(this.attributeList));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.attributeList == null ? 0 : this.attributeList.hashCode());
        result = 31 * result + (this.relationName == null ? 0 : this.relationName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InstanceSchema other = (InstanceSchema)obj;
        if (this.attributeList == null ? other.attributeList != null : !this.attributeList.equals(other.attributeList)) {
            return false;
        }
        return !(this.relationName == null ? other.relationName != null : !this.relationName.equals(other.relationName));
    }
}

