/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.schema.attribute;

import ai.libs.jaicore.ml.core.dataset.schema.attribute.ARankingAttribute;
import ai.libs.jaicore.ml.core.dataset.schema.attribute.LabelRankingAttributeValue;
import java.util.Collection;
import java.util.HashSet;
import org.api4.java.ai.ml.core.dataset.schema.attribute.IRankingAttributeValue;
import org.api4.java.ai.ml.ranking.IRanking;

public class LabelRankingAttribute
extends ARankingAttribute<String> {
    private static final long serialVersionUID = -7357189772771718391L;
    private final Collection<String> labels;

    public LabelRankingAttribute(String name, Collection<String> labels) {
        super(name);
        this.labels = labels;
    }

    public boolean isValidValue(Object value) {
        if (value instanceof IRanking) {
            IRanking ranking = (IRanking)value;
            HashSet<String> labelsInRanking = new HashSet<String>();
            for (Object rankedObject : ranking) {
                if (rankedObject instanceof String) {
                    labelsInRanking.add((String)rankedObject);
                    continue;
                }
                return false;
            }
            return this.labels.containsAll(labelsInRanking);
        }
        return value instanceof LabelRankingAttributeValue;
    }

    public Collection<String> getLabels() {
        return this.labels;
    }

    public String getStringDescriptionOfDomain() {
        return "[LR] " + this.getName() + " " + this.labels;
    }

    public IRankingAttributeValue<String> getAsAttributeValue(Object object) {
        return new LabelRankingAttributeValue(this, this.getValueAsTypeInstance(object));
    }

    @Override
    protected IRanking<String> getValueAsTypeInstance(Object object) {
        if (this.isValidValue(object)) {
            if (object instanceof LabelRankingAttributeValue) {
                return ((LabelRankingAttributeValue)object).getValue();
            }
            return (IRanking)object;
        }
        throw new IllegalArgumentException("No valid value of this attribute");
    }

    public double toDouble(Object object) {
        throw new UnsupportedOperationException("Not yet implemented in LabelRankingAttribute");
    }

    public String serializeAttributeValue(Object value) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    public Object deserializeAttributeValue(String string) {
        throw new UnsupportedOperationException("Not yet implemented.");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.labels == null ? 0 : this.labels.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LabelRankingAttribute other = (LabelRankingAttribute)obj;
        return !(this.labels == null ? other.labels != null : !this.labels.equals(other.labels));
    }
}

