/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.schema.attribute;

import ai.libs.jaicore.ml.core.dataset.schema.attribute.AAttribute;
import ai.libs.jaicore.ml.core.dataset.schema.attribute.NumericAttributeValue;
import org.apache.commons.lang3.math.NumberUtils;
import org.api4.java.ai.ml.core.dataset.schema.attribute.IAttributeValue;
import org.api4.java.ai.ml.core.dataset.schema.attribute.INumericAttribute;
import org.api4.java.ai.ml.core.dataset.schema.attribute.INumericAttributeValue;

public class NumericAttribute
extends AAttribute
implements INumericAttribute {
    private static final long serialVersionUID = 657993241775006166L;

    public NumericAttribute(String name) {
        super(name);
    }

    public boolean isValidValue(Object value) {
        return value == null || value instanceof Number || value instanceof INumericAttributeValue;
    }

    public String getStringDescriptionOfDomain() {
        return "[Num] " + this.getName();
    }

    private double getAttributeValueAsDouble(Object attributeValue) {
        if (attributeValue == null) {
            return Double.NaN;
        }
        if (attributeValue instanceof INumericAttributeValue) {
            return ((INumericAttributeValue)attributeValue).getValue();
        }
        if (attributeValue instanceof Integer) {
            return (double)((Integer)attributeValue).intValue() * 1.0;
        }
        if (attributeValue instanceof Long) {
            return (double)((Long)attributeValue).longValue() * 1.0;
        }
        if (attributeValue instanceof Double) {
            return (Double)attributeValue;
        }
        if (attributeValue instanceof String && NumberUtils.isCreatable((String)((String)attributeValue))) {
            return NumberUtils.createDouble((String)((String)attributeValue));
        }
        throw new IllegalArgumentException("No valid attribute value " + attributeValue + " for attribute " + this.getClass().getName());
    }

    public INumericAttributeValue getAsAttributeValue(Object obj) {
        return new NumericAttributeValue(this, this.getAttributeValueAsDouble(obj));
    }

    public double encodeValue(Object attributeValue) {
        if (!this.isValidValue(attributeValue)) {
            throw new IllegalArgumentException("No valid attribute value");
        }
        return this.getAttributeValueAsDouble(attributeValue);
    }

    public Double decodeValue(double encodedAttributeValue) {
        return encodedAttributeValue;
    }

    public IAttributeValue getAsAttributeValue(double encodedAttributeValue) {
        return new NumericAttributeValue(this, encodedAttributeValue);
    }

    public double toDouble(Object object) {
        return this.getAttributeValueAsDouble(object);
    }

    public String serializeAttributeValue(Object value) {
        if (value == null) {
            return "?";
        }
        return this.getAttributeValueAsDouble(value) + "";
    }

    public Double deserializeAttributeValue(String string) {
        if (string.equals("?")) {
            return null;
        }
        return Double.parseDouble(string);
    }
}

