/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.dataset.schema.attribute;

import ai.libs.jaicore.ml.core.dataset.schema.attribute.ACollectionOfObjectsAttribute;
import ai.libs.jaicore.ml.core.dataset.schema.attribute.SetOfObjectsAttributeValue;
import java.util.Collection;
import java.util.Set;
import java.util.StringJoiner;
import org.api4.java.ai.ml.core.dataset.schema.attribute.IAttributeValue;
import org.api4.java.ai.ml.core.dataset.schema.attribute.ISetOfObjectsAttribute;
import org.api4.java.ai.ml.core.dataset.schema.attribute.ISetOfObjectsAttributeValue;

public class SetOfObjectsAttribute<O>
extends ACollectionOfObjectsAttribute<O>
implements ISetOfObjectsAttribute<O> {
    private static final long serialVersionUID = 4372755490714119056L;
    private Class<O> classOfObject;
    private transient Set<O> domain;

    public SetOfObjectsAttribute(String name, Class<O> classOfObject, Set<O> domain) {
        super(name);
        this.domain = domain;
        this.classOfObject = classOfObject;
    }

    public SetOfObjectsAttribute(String name, Class<O> classOfObject) {
        this(name, classOfObject, null);
    }

    public boolean isValidValue(Object value) {
        Object anyElement;
        Set set;
        if (value instanceof Set && !(set = (Set)value).isEmpty() && this.classOfObject.isInstance(anyElement = set.iterator().next()) && this.domain != null) {
            return set.stream().allMatch(o -> this.domain.contains(o));
        }
        if (value instanceof SetOfObjectsAttributeValue) {
            Object setOfObjects = ((SetOfObjectsAttributeValue)value).getValue();
            return this.isValidValue(setOfObjects);
        }
        return false;
    }

    public String getStringDescriptionOfDomain() {
        String description = "[Set]";
        if (this.domain != null) {
            StringJoiner stringJoiner = new StringJoiner(",");
            for (O object : this.domain) {
                stringJoiner.add(object.toString());
            }
            description = description + stringJoiner.toString();
        }
        return description + this.getName();
    }

    public IAttributeValue getAsAttributeValue(Object object) {
        if (this.isValidValue(object)) {
            if (object instanceof SetOfObjectsAttributeValue) {
                return new SetOfObjectsAttributeValue(((SetOfObjectsAttributeValue)object).getValue(), this);
            }
            return new SetOfObjectsAttributeValue((Set)object, this);
        }
        throw new IllegalArgumentException("No valid value of this attribute");
    }

    public double toDouble(Object object) {
        throw new UnsupportedOperationException("Not supported");
    }

    public String serializeAttributeValue(Object value) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Object deserializeAttributeValue(String string) {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    @Override
    protected Collection<O> getValueAsTypeInstance(Object object) {
        Object elementFromSet;
        Set set;
        if (this.isValidValue(object) && object instanceof ISetOfObjectsAttributeValue && !(set = ((ISetOfObjectsAttributeValue)object).getValue()).isEmpty() && this.classOfObject.isInstance(elementFromSet = set.iterator().next())) {
            return ((ISetOfObjectsAttributeValue)object).getValue();
        }
        throw new IllegalArgumentException("No valid value for the type");
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.classOfObject == null ? 0 : this.classOfObject.hashCode());
        result = 31 * result + (this.domain == null ? 0 : this.domain.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SetOfObjectsAttribute other = (SetOfObjectsAttribute)obj;
        if (this.classOfObject == null ? other.classOfObject != null : !this.classOfObject.equals(other.classOfObject)) {
            return false;
        }
        return !(this.domain == null ? other.domain != null : !this.domain.equals(other.domain));
    }
}

