/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation;

import java.util.List;
import org.api4.java.ai.ml.core.evaluation.IPredictionAndGroundTruthTable;
import org.api4.java.ai.ml.core.evaluation.execution.IAggregatedPredictionPerformanceMeasure;
import org.api4.java.ai.ml.core.evaluation.supervised.loss.IDeterministicPredictionPerformanceMeasure;

public class SingleEvaluationAggregatedMeasure<E, A>
implements IAggregatedPredictionPerformanceMeasure<E, A> {
    private final IDeterministicPredictionPerformanceMeasure<E, A> lossFunction;

    public SingleEvaluationAggregatedMeasure(IDeterministicPredictionPerformanceMeasure<E, A> lossFunction) {
        this.lossFunction = lossFunction;
    }

    public double loss(List<List<? extends E>> expected, List<List<? extends A>> actual) {
        if (expected.size() != 1) {
            throw new IllegalArgumentException();
        }
        return this.lossFunction.loss(expected.get(0), actual.get(0));
    }

    public double loss(List<IPredictionAndGroundTruthTable<? extends E, ? extends A>> pairTables) {
        if (pairTables.size() != 1) {
            throw new IllegalArgumentException();
        }
        return this.lossFunction.loss(pairTables.get(0));
    }

    public double score(List<List<? extends E>> expected, List<List<? extends A>> actual) {
        return 1.0 - this.loss(expected, actual);
    }

    public double score(List<IPredictionAndGroundTruthTable<? extends E, ? extends A>> pairTables) {
        return 1.0 - this.loss(pairTables);
    }

    public IDeterministicPredictionPerformanceMeasure<E, A> getBaseMeasure() {
        return this.lossFunction;
    }
}

