/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation.evaluator;

import ai.libs.jaicore.logging.ToJSONStringUtil;
import java.util.HashMap;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.evaluation.IPredictionAndGroundTruthTable;
import org.api4.java.ai.ml.core.evaluation.execution.ILearnerRunReport;

public class LearnerRunReport
implements ILearnerRunReport {
    private final ILabeledDataset<?> trainSet;
    private final ILabeledDataset<?> testSet;
    private final long trainStartTime;
    private final long trainEndTime;
    private final long testStartTime;
    private final long testEndTime;
    private final Throwable exception;
    private final IPredictionAndGroundTruthTable diff;

    public LearnerRunReport(ILabeledDataset<?> trainSet, ILabeledDataset<?> testSet, long trainStartTime, long trainEndTime, Throwable exception) {
        this.trainSet = trainSet;
        this.testSet = testSet;
        this.trainStartTime = trainStartTime;
        this.trainEndTime = trainEndTime;
        this.testStartTime = -1L;
        this.testEndTime = -1L;
        this.diff = null;
        this.exception = exception;
    }

    public LearnerRunReport(ILabeledDataset<?> trainSet, ILabeledDataset<?> testSet, long trainStartTime, long trainEndTime, long testStartTime, long testEndTime, Throwable exception) {
        this.trainSet = trainSet;
        this.testSet = testSet;
        this.trainStartTime = trainStartTime;
        this.trainEndTime = trainEndTime;
        this.testStartTime = testStartTime;
        this.testEndTime = testEndTime;
        this.diff = null;
        this.exception = exception;
    }

    public LearnerRunReport(ILabeledDataset<?> trainSet, ILabeledDataset<?> testSet, long trainStartTime, long trainEndTime, long testStartTime, long testEndTime, IPredictionAndGroundTruthTable diff) {
        this.trainSet = trainSet;
        this.testSet = testSet;
        this.trainStartTime = trainStartTime;
        this.trainEndTime = trainEndTime;
        this.testStartTime = testStartTime;
        this.testEndTime = testEndTime;
        this.diff = diff;
        this.exception = null;
    }

    public long getTrainStartTime() {
        return this.trainStartTime;
    }

    public long getTrainEndTime() {
        return this.trainEndTime;
    }

    public long getTestStartTime() {
        return this.testStartTime;
    }

    public long getTestEndTime() {
        return this.testEndTime;
    }

    public ILabeledDataset<?> getTrainSet() {
        return this.trainSet;
    }

    public ILabeledDataset<?> getTestSet() {
        return this.testSet;
    }

    public IPredictionAndGroundTruthTable getPredictionDiffList() {
        return this.diff;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String toString() {
        HashMap<String, Object> fields = new HashMap<String, Object>();
        fields.put("trainStartTime", this.trainStartTime);
        fields.put("trainEndTime", this.trainEndTime);
        fields.put("testStartTime", this.testStartTime);
        fields.put("testEndTime", this.testEndTime);
        fields.put("exception", this.exception);
        fields.put("diffClass", this.diff.getClass().getName());
        return ToJSONStringUtil.toJSONString((String)this.getClass().getSimpleName(), fields);
    }
}

