/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation.evaluator;

import ai.libs.jaicore.ml.core.filter.sampling.inmemory.ASamplingAlgorithm;
import ai.libs.jaicore.ml.core.filter.sampling.inmemory.factories.interfaces.ISamplingAlgorithmFactory;
import ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.InvalidAnchorPointsException;
import ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.LearningCurveExtrapolatedEvent;
import ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.LearningCurveExtrapolationMethod;
import ai.libs.jaicore.ml.functionprediction.learner.learningcurveextrapolation.LearningCurveExtrapolator;
import com.google.common.eventbus.EventBus;
import org.api4.java.ai.ml.classification.IClassifierEvaluator;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.ai.ml.core.evaluation.learningcurve.ILearningCurve;
import org.api4.java.ai.ml.core.exception.DatasetCreationException;
import org.api4.java.ai.ml.core.learner.ISupervisedLearner;
import org.api4.java.algorithm.exceptions.AlgorithmException;
import org.api4.java.common.attributedobjects.ObjectEvaluationFailedException;
import org.api4.java.common.control.ILoggingCustomizable;
import org.api4.java.common.event.IEventEmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LearningCurveExtrapolationEvaluator
implements IClassifierEvaluator,
ILoggingCustomizable,
IEventEmitter<Object> {
    private Logger logger = LoggerFactory.getLogger(LearningCurveExtrapolationEvaluator.class);
    private int[] anchorpoints;
    private ISamplingAlgorithmFactory<ILabeledDataset<?>, ? extends ASamplingAlgorithm<ILabeledDataset<?>>> samplingAlgorithmFactory;
    private ILabeledDataset<?> dataset;
    private double trainSplitForAnchorpointsMeasurement;
    private LearningCurveExtrapolationMethod extrapolationMethod;
    private long seed;
    private int fullDatasetSize = -1;
    private static final boolean EVALUATE_ACCURACY = false;
    private final EventBus eventBus = new EventBus();

    public LearningCurveExtrapolationEvaluator(int[] anchorpoints, ISamplingAlgorithmFactory<ILabeledDataset<?>, ? extends ASamplingAlgorithm<ILabeledDataset<?>>> samplingAlgorithmFactory, ILabeledDataset<?> dataset, double trainSplitForAnchorpointsMeasurement, LearningCurveExtrapolationMethod extrapolationMethod, long seed) {
        this.anchorpoints = anchorpoints;
        this.samplingAlgorithmFactory = samplingAlgorithmFactory;
        this.dataset = dataset;
        this.trainSplitForAnchorpointsMeasurement = trainSplitForAnchorpointsMeasurement;
        this.extrapolationMethod = extrapolationMethod;
        this.seed = seed;
    }

    public void setFullDatasetSize(int fullDatasetSize) {
        this.fullDatasetSize = fullDatasetSize;
    }

    public Double evaluate(ISupervisedLearner<ILabeledInstance, ILabeledDataset<? extends ILabeledInstance>> classifier) throws InterruptedException, ObjectEvaluationFailedException {
        this.logger.info("Receive request to evaluate classifier {}", classifier);
        try {
            LearningCurveExtrapolator extrapolator = new LearningCurveExtrapolator(this.extrapolationMethod, classifier, this.dataset, this.trainSplitForAnchorpointsMeasurement, this.anchorpoints, this.samplingAlgorithmFactory, this.seed);
            extrapolator.setLoggerName(this.getLoggerName() + ".extrapolator");
            this.logger.debug("Extrapolating learning curve.");
            ILearningCurve learningCurve = extrapolator.extrapolateLearningCurve();
            this.logger.debug("Retrieved learning curve {}.", (Object)learningCurve);
            this.eventBus.post((Object)new LearningCurveExtrapolatedEvent(extrapolator));
            int evaluationPoint = this.dataset.size();
            if (this.fullDatasetSize != -1) {
                evaluationPoint = this.fullDatasetSize;
            }
            Double val = 1.0 - learningCurve.getCurveValue((double)evaluationPoint);
            this.logger.info("Estimate for performance on full dataset is {}", (Object)val);
            return val;
        }
        catch (InvalidAnchorPointsException | DatasetCreationException | AlgorithmException e) {
            throw new ObjectEvaluationFailedException("Could not compute a score based on the learning curve.", e);
        }
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger = LoggerFactory.getLogger((String)name);
    }

    public void registerListener(Object listener) {
        this.eventBus.register(listener);
    }
}

