/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation.evaluator;

import ai.libs.jaicore.ml.classification.loss.dataset.EAggregatedClassifierMetric;
import ai.libs.jaicore.ml.core.dataset.splitter.RandomHoldoutSplitter;
import ai.libs.jaicore.ml.core.evaluation.evaluator.TrainPredictionBasedClassifierEvaluator;
import ai.libs.jaicore.ml.core.evaluation.splitsetgenerator.FixedDataSplitSetGenerator;
import ai.libs.jaicore.ml.core.evaluation.splitsetgenerator.MonteCarloCrossValidationSplitSetGenerator;
import java.util.Random;
import org.api4.java.ai.ml.core.dataset.splitter.IRandomDatasetSplitter;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledInstance;
import org.api4.java.ai.ml.core.evaluation.execution.IAggregatedPredictionPerformanceMeasure;

public class MonteCarloCrossValidationEvaluator
extends TrainPredictionBasedClassifierEvaluator {
    private final IRandomDatasetSplitter<ILabeledDataset<ILabeledInstance>> datasetSplitter;
    private final int repeats;
    private final Random random;
    private final IAggregatedPredictionPerformanceMeasure metric;

    public MonteCarloCrossValidationEvaluator(ILabeledDataset<? extends ILabeledInstance> data, int repeats, double trainingPortion, Random random) {
        this(data, new RandomHoldoutSplitter<ILabeledDataset<ILabeledInstance>>(trainingPortion), repeats, random, (IAggregatedPredictionPerformanceMeasure)EAggregatedClassifierMetric.MEAN_ERRORRATE);
    }

    public MonteCarloCrossValidationEvaluator(ILabeledDataset<? extends ILabeledInstance> data, int repeats, double trainingPortion, Random random, IAggregatedPredictionPerformanceMeasure metric) {
        this(data, new RandomHoldoutSplitter<ILabeledDataset<ILabeledInstance>>(trainingPortion), repeats, random, metric);
    }

    public MonteCarloCrossValidationEvaluator(ILabeledDataset<? extends ILabeledInstance> data, IRandomDatasetSplitter<ILabeledDataset<ILabeledInstance>> datasetSplitter, int repeats, Random random, IAggregatedPredictionPerformanceMeasure metric) {
        super(new FixedDataSplitSetGenerator(data, new MonteCarloCrossValidationSplitSetGenerator<ILabeledDataset<ILabeledInstance>>(datasetSplitter, repeats, random)), metric);
        this.datasetSplitter = datasetSplitter;
        this.repeats = repeats;
        this.random = random;
        this.metric = metric;
    }

    public String toString() {
        return "MonteCarloCrossValidationEvaluator [splitter = " + this.datasetSplitter + ", repeats = " + this.repeats + ", Random = " + this.random + ", metric = " + this.metric.getBaseMeasure() + "]";
    }
}

