/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.evaluation.splitsetgenerator;

import ai.libs.jaicore.ml.core.dataset.splitter.DatasetSplitSet;
import java.util.ArrayList;
import java.util.Random;
import org.api4.java.ai.ml.core.dataset.splitter.IRandomDatasetSplitter;
import org.api4.java.ai.ml.core.dataset.splitter.SplitFailedException;
import org.api4.java.ai.ml.core.dataset.supervised.ILabeledDataset;
import org.api4.java.ai.ml.core.evaluation.execution.IDatasetSplitSet;
import org.api4.java.ai.ml.core.evaluation.execution.IDatasetSplitSetGenerator;
import org.api4.java.common.control.ILoggingCustomizable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonteCarloCrossValidationSplitSetGenerator<D extends ILabeledDataset<?>>
implements IDatasetSplitSetGenerator<D>,
ILoggingCustomizable {
    private Logger logger = LoggerFactory.getLogger(MonteCarloCrossValidationSplitSetGenerator.class);
    private final IRandomDatasetSplitter<D> datasetSplitter;
    private final int repeats;
    private final long seed;
    private int runningSeed;

    public MonteCarloCrossValidationSplitSetGenerator(IRandomDatasetSplitter<D> datasetSplitter, int repeats, Random random) {
        this.datasetSplitter = datasetSplitter;
        this.repeats = repeats;
        if (repeats <= 0) {
            throw new IllegalArgumentException("Cannot create MCCV split generator for non-positive number of repeats " + repeats + ". Set A positive number of repeats.");
        }
        this.seed = random.nextLong();
    }

    public String getLoggerName() {
        return this.logger.getName();
    }

    public void setLoggerName(String name) {
        this.logger.info("Switching logger of {} from {} to {}", new Object[]{this, this.logger.getName(), name});
        this.logger = LoggerFactory.getLogger((String)name);
        this.logger.info("Switched logger of {} to {}", (Object)this, (Object)name);
        if (this.datasetSplitter instanceof ILoggingCustomizable) {
            ((ILoggingCustomizable)this.datasetSplitter).setLoggerName(name + ".splitter");
            this.logger.info("Setting logger of splitter {} to {}.splitter", (Object)this.datasetSplitter.getClass().getName(), (Object)name);
        } else {
            this.logger.info("Base splitter {} is not configurable for logging, so not configuring it.", (Object)this.datasetSplitter.getClass().getName());
        }
    }

    public int getNumSplitsPerSet() {
        return this.repeats;
    }

    public int getNumFoldsPerSplit() {
        return this.datasetSplitter.getNumberOfFoldsPerSplit();
    }

    public IDatasetSplitSet<D> nextSplitSet(D data) throws InterruptedException, SplitFailedException {
        this.logger.info("Generating next split set of size {} for dataset with {} instances.", (Object)this.repeats, (Object)data.size());
        if (Thread.interrupted()) {
            this.logger.info("MCCV has been interrupted, leaving MCCV.");
            throw new InterruptedException("MCCV has been interrupted.");
        }
        ArrayList splits = new ArrayList(this.repeats);
        for (int i = 0; i < this.repeats; ++i) {
            long vSeed = this.seed + (long)this.runningSeed;
            this.logger.debug("Invoking dataset splitter {} with Random({})", this.datasetSplitter, (Object)vSeed);
            splits.add(this.datasetSplitter.split(data, new Random(vSeed)));
            ++this.runningSeed;
        }
        return new DatasetSplitSet(splits);
    }

    public String toString() {
        return "MonteCarloCrossValidationSplitSetGenerator [datasetSplitter=" + this.datasetSplitter + ", repeats=" + this.repeats + ", seed=" + this.seed + "]";
    }
}

