/*
 * Decompiled with CFR 0.152.
 */
package ai.libs.jaicore.ml.core.filter.sampling.infiles;

import ai.libs.jaicore.basic.TempFileHandler;
import ai.libs.jaicore.ml.core.filter.sampling.infiles.ArffUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Comparator;
import org.api4.java.algorithm.exceptions.AlgorithmExecutionCanceledException;
import org.api4.java.common.control.ICancelable;

public class DatasetFileSorter
implements ICancelable {
    private File datasetFile;
    private TempFileHandler tempFileHandler;
    private boolean usesOwnTempFileHandler;
    private boolean canceled;
    private Comparator<String> comparator = (s1, s2) -> {
        String[] f1 = s1.trim().split(",");
        String[] f2 = s2.trim().split(",");
        int l = Math.min(f1.length, f2.length);
        for (int i = 0; i < l; ++i) {
            int c = f1[i].compareTo(f2[i]);
            if (c == 0) continue;
            return c;
        }
        return 0;
    };

    public DatasetFileSorter(File datasetFile, TempFileHandler tempFileHandler) {
        this.datasetFile = datasetFile;
        if (!datasetFile.exists()) {
            throw new IllegalArgumentException("Cannot sort items of non-existent file " + datasetFile);
        }
        this.tempFileHandler = tempFileHandler;
        this.usesOwnTempFileHandler = false;
    }

    public DatasetFileSorter(File datasetFile) {
        this(datasetFile, new TempFileHandler());
        this.usesOwnTempFileHandler = true;
    }

    public void setComparator(Comparator<String> comparator) {
        this.comparator = comparator;
    }

    /*
     * Exception decompiling
     */
    public File sort(String sortedFilePath) throws IOException, InterruptedException, AlgorithmExecutionCanceledException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private String mergesort(String fileUUID) throws IOException, InterruptedException, AlgorithmExecutionCanceledException {
        String line;
        int length = ArffUtilities.countDatasetEntries(this.tempFileHandler.getTempFile(fileUUID), false);
        if (length <= 1) {
            return fileUUID;
        }
        String leftUUID = this.tempFileHandler.createTempFile();
        String rightUUID = this.tempFileHandler.createTempFile();
        FileWriter leftWriter = this.tempFileHandler.getFileWriterForTempFile(leftUUID);
        FileWriter rightWriter = this.tempFileHandler.getFileWriterForTempFile(rightUUID);
        BufferedReader reader = this.tempFileHandler.getFileReaderForTempFile(fileUUID);
        int i = 0;
        while ((line = reader.readLine()) != null) {
            if (i % 100 == 0 && Thread.interrupted()) {
                throw new InterruptedException();
            }
            if (i < length / 2) {
                leftWriter.write(line + "\n");
            } else {
                rightWriter.write(line + "\n");
            }
            ++i;
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        leftWriter.flush();
        rightWriter.flush();
        String sortedLeftUUID = this.mergesort(leftUUID);
        String sortedRightUUID = this.mergesort(rightUUID);
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.canceled) {
            throw new AlgorithmExecutionCanceledException(0L);
        }
        String mergedFileUUID = this.merge(sortedLeftUUID, sortedRightUUID);
        this.tempFileHandler.deleteTempFile(leftUUID);
        this.tempFileHandler.deleteTempFile(rightUUID);
        return mergedFileUUID;
    }

    private String merge(String leftUUID, String rightUUID) throws IOException {
        String uuid = this.tempFileHandler.createTempFile();
        FileWriter writer = this.tempFileHandler.getFileWriterForTempFile(uuid);
        BufferedReader leftReader = this.tempFileHandler.getFileReaderForTempFile(leftUUID);
        BufferedReader rightReader = this.tempFileHandler.getFileReaderForTempFile(rightUUID);
        String leftLine = leftReader.readLine();
        String rightLine = rightReader.readLine();
        while (leftLine != null || rightLine != null) {
            if (leftLine == null) {
                writer.write(rightLine + "\n");
                rightLine = rightReader.readLine();
                continue;
            }
            if (rightLine == null) {
                writer.write(leftLine + "\n");
                leftLine = leftReader.readLine();
                continue;
            }
            int c = this.comparator.compare(leftLine, rightLine);
            if (c > 0) {
                writer.write(rightLine + "\n");
                rightLine = rightReader.readLine();
                continue;
            }
            writer.write(leftLine + "\n");
            leftLine = leftReader.readLine();
        }
        writer.flush();
        return uuid;
    }

    public void cancel() {
        this.canceled = true;
    }
}

